/**************************************************************************
**                                                                        *
**  FILE        :  strrchr.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for strrchr() routine                      *
**                 Search the string for the last occurrence of the       *
**                 given character.                                       *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <string.h>

char *
strrchr( register const char *cs, int c )
{
	register const char *os = cs;

	while ( *os )
	{
		os++;
	}
	/* os points to terminating null byte */
	do
	{
		if ( *os == (char)c )
		{
			return( (char *)os );
		}
	} while ( os-- != cs );
	return NULL;
}
