/**************************************************************************
**                                                                        *
**  FILE        :  strncat.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for strncat() routine                      *
**                 Catenates two strings to eachother. A maximum length   *
**                 can be given.                                          *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <string.h>

char *
strncat( register char * restrict s1, register const char * restrict s2,
	 register size_t n )
{
	register char *os1 = s1;

	if ( n-- )
	{
		while (*os1++)
		{
			/* No action */
			;
		}

		--os1;
		while ( (*os1++ = *s2++) )
		{
			if( !n-- )
			{
				*os1 = '\0';
				break;
			}
		}
	}

	return s1;
}
