/**************************************************************************
**                                                                        *
**  FILE        :  strcmp.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for strcmp() routine                       *
**                 Compares two strings.                                  *
**                 Returns : < 0  -- s1<s2                                *
**                           = 0  -- s1=s2                                *
**                           > 0  -- s1>s2                                *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <string.h>

int
strcmp( const char * s1, const char * s2 )
{
	unsigned char c1, c2;
	do
	{
		c2 = *s2++;
		c1 = *s1++;
	} while ( c1 != '\0' && c1 == c2);
	return( (int)c1 - (int)c2 );
}
