/**************************************************************************
**                                                                        *
**  FILE        :  scalbf.c                                               *
**                                                                        *
**  DESCRIPTION :  The scalbnf() function.                                *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

/*****************************************************************************
|*
|* FUNCTION     : scalbnf
|*
|* PARAMETERS   :
|*
|*      variable to multiply, multiplication factor's power
|*
|* RETURN VALUE :
|*
|*      multiplication of first argument with 2 to the power of the second
|*      argument
|*
|* DESCRIPTION  :
|*
|*     IEEE-754-1985 Recommended function.
|*     Returns v * 2^pwr.
|*
|*     No exception handling, since that is oddly enough not specified
|*     by IEEE-754-1985.
|*
*/
#ifdef	__SINGLE_FP__
#pragma alias	scalbn		= _scalbn_spf
#pragma alias	scalbnl		= _scalbn_spf
#endif
#pragma alias	scalbnf		= _scalbn_spf
#pragma alias	scalbf		= _scalbn_spf
static
float	_scalbn_spf( float v, int pwr )
{
#if _IEEE_754_FORMAT
	float2long_t	u;
	unsigned long	l;
	int		exponent;

	/* double type mapped to float type by compiler */
	u.f	= v;
	l	= u.l;

	exponent	= GET_FLOAT_EXPONENT( l );
	exponent	+= pwr;
	l		= STRIP_FLOAT_EXPONENT( l );
	l		= PUT_FLOAT_EXPONENT( l, exponent );

	u.l	= l;
	return u.f;
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
}
