/**************************************************************************
**                                                                        *
**  FILE        :  scalb.c                                                *
**                                                                        *
**  DESCRIPTION :  The scalbn() function.                                 *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

/*****************************************************************************
|*
|* FUNCTION     : scalbn
|*
|* PARAMETERS   :
|*
|*      variable to multiply, multiplication factor's power
|*
|* RETURN VALUE :
|*
|*      multiplication of first argument with 2 to the power of the second
|*      argument
|*
|* DESCRIPTION  :
|*
|*     IEEE-754-1985 Recommended function.
|*     Returns v * 2^pwr.
|*
|*     No exception handling, since that is oddly enough not specified
|*     by IEEE-754-1985.
|*
*/
#ifndef	__SINGLE_FP__
#pragma alias	scalbn		= _scalbn_dpf
#pragma alias	scalbnl		= _scalbn_dpf
#pragma alias	scalb		= _scalbn_dpf
static
double	_scalbn_dpf( double v, int pwr )
{
#if _IEEE_754_FORMAT
	double2longs_t	u;
	unsigned long	hi;
	int		exponent;

	u.d	= v;
	hi	= u.s.hi;

	exponent	= GET_DOUBLE_EXPONENT( hi );
	exponent	+= pwr;
	hi		= STRIP_DOUBLE_EXPONENT( hi );
	hi		= PUT_DOUBLE_EXPONENT( hi, exponent );

	u.s.hi	= hi;
	return u.d;
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
}
#endif
