/**************************************************************************
**                                                                        *
**  FILE        :  realloc.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for realloc()                              *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdlib.h>
#include <string.h>
#include "_malloc.h"

#pragma	weak	realloc
#pragma	alias	_realloc	= realloc

extern	void*	realloc ( void* mem, size_t newsize )
{
	void*	newmem;
	msize_t	size;

	newmem = malloc( newsize );
	if	( ! mem )
	{	/* ANSI requirement: behave like malloc() */
		return newmem;
	}
	if	( newmem )	/* implies (newsize != 0) */
	{
		size = *(msize_t*)((mptr_t)mem - HEADER);
		if	( ! (size & 1) )
		{
			free( newmem );
			return NULL;	/* old block already freed! */
		}
		size = (size & ~ 1) - HEADER;
		if	( size < newsize )
		{
			newsize = (size_t) size;
		}
		(void) memcpy( newmem, mem, newsize );
	}
	if	( newmem || newsize == 0 )
	{
		free( mem );
	}
	return newmem;
}
