/**************************************************************************
**                                                                        *
**  FILE        :  pow.c                                                  *
**                                                                        *
**  DESCRIPTION :  Source file for pow() routine                          *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <errno.h>
#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias	powl	= _pow_spf
#pragma alias	pow		= _pow_spf
#endif
#pragma alias	powf	= _pow_spf


static
float
_pow_spf( float arg1, float arg2 )
{
	long	l;

	if( arg1 <= 0.0f )
	{
		if( arg1 == 0.0f )
		{
			if( arg2 <= 0.0f )
				errno = EDOM;
			return( 0.0f );
		}
		l = arg2;
		if( l != arg2 )
		{
			errno = EDOM;
			return( 0.0f );
		}
		arg1 = expf( arg2 * logf( -arg1 ) );
		return( (l & 1) ? -arg1 : arg1 );
	}
	return( expf( arg2 * logf( arg1 ) ) );
}


