/**************************************************************************
**                                                                        *
**  FILE        :  log.c                                                  *
**                                                                        *
**  DESCRIPTION :  Source file for log() routine                          *
**                 Computes the 'natural logarithm' for the given value   *
**                                                                        *
**        The double coefficients are #2704 from Hart & Cheney. (16.65D)  *
**        The single coefficients are #2701 from Hart & Cheney. ( 8.48D)  *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <errno.h>
#include <math.h>

#if 0


#define	LOG2	( 0.693147180559945309e0l)
#define	SQRTO2	( 0.707106781186547524e0l)
#define	P0	(-0.90174691662040536328986e2)
#define	P1	( 0.934639006428585382474e2)
#define	P2	(-0.18327870372215593212e2)
#define	Q0	(-0.45087345831020305748486e2)
#define	Q1	( 0.61761065598471302843e2)
#define	Q2	(-0.20733487895513939345e2)
#define POLYNOMIAL(zsq,arg,exp)	( ( ( ( P2 * (zsq) + P1 ) * (zsq) + P0 ) / \
			( ( ( (zsq) + Q2 ) * (zsq) + Q1 ) * (zsq) + Q0 ) ) * (arg) + (exp) * LOG2 )

static
long double
_log_qpf( long double arg )
{
	long double	zsq;
	int	exp;

	if( arg <= 0.0l )
	{
	        if ( arg == 0.0l )
		{		    
		    errno = ERANGE;
		}
		else
		{
		    errno = EDOM;
		}				    
		return( -HUGE_VALL );
	}
	arg = frexpl( arg, &exp );
	if( arg < SQRTO2 )
	{
		arg = 2.0l * arg;
		exp = exp - 1;
	}

	arg = ( arg - 1.0l ) / ( arg + 1.0l );
	zsq = arg * arg;

	return POLYNOMIAL(zsq,arg,exp);
}

#endif

