/**************************************************************************
**                                                                        *
**  FILE        :  lldiv.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for lldiv() routine                        *
**                 Returns a structure with the quotient an remainder of  *
**                 num divided by denom.                                  *
**	NOTE	   Cannot be shared code, using static data for           *
**		   structure result.                                      *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdlib.h>

lldiv_t
lldiv( long long num, long long denom )
{
	lldiv_t result;

	result.quot = num / denom;
	result.rem  = num % denom;
	return( result );
}
