/**************************************************************************
**                                                                        *
**  FILE        :  iswxdigit.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for iswxdigit routine.                     *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

#undef iswxdigit

/*
 * Test for wide character that corresponds to a hexadecimal-digit 
 * character.
 * Return 0 on failure.
 */
int iswxdigit(wint_t wc)
{
	return iswctype(wc, _xdigit);
}

#endif
