/**************************************************************************
**                                                                        *
**  FILE        :  isnanf.c                                               *
**                                                                        *
**  DESCRIPTION :  The isnanf() function.                                 *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

/*****************************************************************************
|*
|* FUNCTION     : isnanf
|*
|* PARAMETERS   :
|*
|*      float type variable to test
|*
|* RETURN VALUE :
|*
|*      zero if the variable is not NaN, else non-zero
|*
|* DESCRIPTION  :
|*
|*     IEEE-754-1985 Recommended function.
|*     Test the given variable on being a NaN (IEEE-754) value.
|*
*/
#ifdef	__SINGLE_FP__
#pragma alias	_isnan		= _isnan_spf
#pragma alias	_isnanl		= _isnan_spf
#endif
#pragma alias	_isnanf		= _isnan_spf
static
int	_isnan_spf( float f )
{
#if _IEEE_754_FORMAT
	float2long_t	u;
	unsigned long	l;

	u.f	= f;
	l	= u.l;

	return GET_FLOAT_EXPONENT( l ) == FLOAT_BIASED_NaN_EXP && GET_FLOAT_MANTISSA( l );
#else
#  error not implemented (yet)
#endif /* IEEE 754 format */
}
