/**************************************************************************
**                                                                        *
**  FILE        :  ftell.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for ftell() routine                        *
**                 Returns the current value of the file position         *
**                 indicator for the stream pointed by 'file'.            *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

long ftell(FILE *fp)
{
	long	off;

	off = _lseek(fileno(fp), 0, SEEK_CUR);
	if (off != -1)
	{
		if (!(fp->_flag & _IONBF))
		{
			off += fp->_cnt < 0 ? fp->_cnt + 1 : fp->_ptr - fp->_base;
		}
		else if	(fp->_bufsiz != EOF)
		{
			--off;			/* ungetc buffer hack */
		}
	}
	return off;
}
