/**************************************************************************
**                                                                        *
**  FILE        :  fpbits.h                                               *
**                                                                        *
**  DESCRIPTION :  FP internals libc needs to know for an efficient	  *
**		   implementation.					  *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef	_FPBITS_H
#define	_FPBITS_H

#ifdef	__cplusplus
extern "C" {
#endif	/* defined(__cplusplus) */

/*
 * IEEE-754-1985 floating point format support macro's
 * 32 bit unsigned long size implementation
 */
#define	_IEEE_754_FORMAT	1

/***********************************************************************/

#define	FLOAT_FRACTION_SIZE		23	/* without the hidden bit */
#define	FLOAT_BIAS			127
#define	MIN_FLOAT_BIASED_EXP		1
#define	MAX_FLOAT_BIASED_EXP		0xfe
#define	FLOAT_BIASED_INF_EXP 		0xff
#define	FLOAT_BIASED_NaN_EXP 		0xff
#define	COPY_FLOAT_SIGN( sign, l )	( ((l) & 0x7fffffff) | ((unsigned long)(sign) & 0x80000000) )
#define	GET_FLOAT_SIGN( l )		( ( (l) & 0x80000000 ) ? 1 : 0)
#define	GET_FLOAT_MANTISSA( l )		( (l) & 0x7fffff )
#define	GET_FLOAT_EXPONENT( l )		( ( (l) >> FLOAT_FRACTION_SIZE) & 0xff )
#define	STRIP_FLOAT_EXPONENT( l )	( (l) & 0x807fffff )
#define	PUT_FLOAT_EXPONENT( l, exp )	( (l) | (((unsigned long)(exp) & 0xff) << FLOAT_FRACTION_SIZE) )
#define	PUT_FLOAT_SIGN( l, sign )	( ((l) & 0x7fffffff) | (((unsigned long)(sign) & 0x1) << 31) )
#define	FLOAT_IS_ZERO( l )		( ((l) & 0x7fffffff) == 0 ) /* test mantissa too for denormals */

typedef union
{
	unsigned long	l;
	float		f;
}
float2long_t;


/***********************************************************************/

#define	DOUBLE_FRACTION_SIZE		52	/* without the hidden bit */
#define	DOUBLE_BIAS			1023
#define	MIN_DOUBLE_BIASED_EXP 		1
#define	MAX_DOUBLE_BIASED_EXP		0x7fe
#define	DOUBLE_BIASED_INF_EXP 		0x7ff
#define	DOUBLE_BIASED_NaN_EXP 		0x7ff
#define	COPY_DOUBLE_SIGN( sign, hi )	( ((hi) & 0x7fffffff) | ((unsigned long)(sign) & 0x80000000) )
#define	GET_DOUBLE_SIGN( hi )		( ( (hi) & 0x80000000 ) ? 1 : 0)
#define	GET_DOUBLE_HI_MANTISSA( hi )	( (hi) & ( ( 1L << (DOUBLE_FRACTION_SIZE - 32) ) - 1 ) )
#define	GET_DOUBLE_LO_MANTISSA( lo )	(lo)
#define	GET_DOUBLE_EXPONENT( hi )	( ( (hi) >> (DOUBLE_FRACTION_SIZE - 32) ) & 0x7ff )
#define	STRIP_DOUBLE_EXPONENT( hi )	( (hi) & 0x800fffff )
#define	PUT_DOUBLE_EXPONENT( hi, exp )	( (hi) | (((unsigned long)(exp) & 0x7ff) << (DOUBLE_FRACTION_SIZE - 32) ) )
#define	PUT_DOUBLE_SIGN( hi, sign )	( ((hi) & 0x7fffffff) | (((unsigned long)(sign) & 0x1) << 31 ) )
#define	DOUBLE_IS_ZERO( hi, lo )	( ((hi) & 0x7fffffff) == 0 && (lo) == 0 ) /* also for denormals */


typedef union
{
#if __BIG_ENDIAN__
	struct
	{
		unsigned long	hi;
		unsigned long	lo;
	}
	s;
#else
	struct
	{
		unsigned long	lo;
		unsigned long	hi;
	}
	s;
#endif
	double	d;
}
double2longs_t;


/***********************************************************************/

/*
 * Infinity constants.
 *
 * Float, double and long double in terms of single and double precision.
 */
#if	__STDC_VERSION__ >= 199901L

#define __spf_infinity  (((float2long_t){.l=0x7f800000l}).f)
#define __spf_infinityN (((float2long_t){.l=0xff800000l}).f)
#define __dpf_infinity  (((double2longs_t){.s={.hi=0x7ff00000l,.lo=0x00000000l}}).d)
#define __dpf_infinityN (((double2longs_t){.s={.hi=0xfff00000l,.lo=0x00000000l}}).d)
#define __float_infinity	__spf_infinity
#define __float_infinityN	__spf_infinityN
#ifndef __SINGLE_FP__
#define __double_infinity	__dpf_infinity
#define __double_infinityN	__dpf_infinityN
#else
#define __double_infinity	__spf_infinity
#define __double_infinityN	__spf_infinityN
#endif
#define __long_double_infinity	__dpf_infinity
#define __long_double_infinityN	__dpf_infinityN

#endif

#ifdef	__cplusplus
}
#endif	/* defined(__cplusplus) */

#endif  /* _FPBITS_H */
