/**************************************************************************
**                                                                        *
**  FILE        :  cosh.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for cosh() routine                         *
**                 Computes the 'hyperbolic cosinus' for the given angle  *
**                 (in radians)                                           *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias	coshl	= _cosh_spf
#pragma alias	cosh		= _cosh_spf
#endif
#pragma alias	coshf	= _cosh_spf


#define LOG_HALF (-0.693147180559945309417232121f) /* ln(0.5) */

static
float
_cosh_spf( float arg )
{
	if( arg < 0.0f )
		arg = -arg;

	if( arg > 37.0f )
	{
		return( expf( arg + LOG_HALF ) );
	}

	return( ( expf( arg + LOG_HALF ) + expf( -arg + LOG_HALF ) ) );
}


