/**************************************************************************
**                                                                        *
**  FILE        :  cosh.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for cosh() routine                         *
**                 Computes the 'hyperbolic cosinus' for the given angle  *
**                 (in radians)                                           *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifndef __SINGLE_FP__
#pragma alias	coshl	= _cosh_dpf
#pragma alias	cosh		= _cosh_dpf


#define LOG_HALF (-0.693147180559945309417232121) /* ln(0.5) */

static
double
_cosh_dpf( double arg )
{
	if( arg < 0.0 )
		arg = -arg;

	if( arg > 37.0 )
	{
		return( exp( arg + LOG_HALF ) );
	}

	return( ( exp( arg + LOG_HALF ) + exp( -arg + LOG_HALF ) ) );
}

#endif

