/**************************************************************************
**                                                                        *
**  FILE        :  ceil.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for ceil() routine                         *
**                 Rounds the value to the nearest integer value, not     *
**                 less than the given value                              *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include	<math.h>

#ifdef __SINGLE_FP__
#pragma alias	ceill	= _ceil_spf
#pragma alias	ceil		= _ceil_spf
#endif
#pragma alias	ceilf	= _ceil_spf


static
float
_ceil_spf( float d )
{
	return( -floorf( -d ) );
}


