/**************************************************************************
**                                                                        *
**  FILE        :  btowc.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for btowc routine.                         *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <limits.h>
#include <stdio.h>

#ifdef WCHAR_SUPPORT_ENABLED

#include <wchar.h>

/*
 * Determine whether c constitutes a valid (one-byte) multibyte character 
 * in the initial shift state.
 * 
 * Return WEOF if c has the value of EOF or if (unsigned char) c does not 
 * constitute a valid (one-byte) multibyte character in the initial shift 
 * state. Otherwise, return the wide character representation of that 
 * character.
 */
wint_t btowc(int c)
{
	if (c == EOF
#if UINT_MAX > UCHAR_MAX
	    || (unsigned int) c > (unsigned int) UCHAR_MAX
#endif
	    )
	{
		return WEOF;
	}

	return (wint_t) c;
}

#endif
