/**************************************************************************
**                                                                        *
**  FILE        :  atoi.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for atoi() routine                         *
**                 Converts given string to an int value                  *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdlib.h>

int
atoi( const char * str )
{
	register int result = 0;
	register unsigned char ch;
	unsigned char neg = 0;

	/* Skip white space (we could have used ctype isspace() */
	do
	{
		ch = *str++ - 9;
	} while ( (ch <= 4) || (ch == 23) );	/* white space */

	if ( ch == 36 )			/* check for '-' */
		neg = 1;
	else if ( ch != 34 )		/* check for '+' */
		str--;

	for ( ;; )
	{
		ch = *str++ - '0';

		if ( ch > 9 )
			break;		/* end of string reached */

		if ( neg )
			ch = (signed char)(-((signed char)ch));
		result = 10 * result + (signed char)ch;
	}
	return result;
}
