/**************************************************************************
**                                                                        *
**  FILE        :  atan.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for atan() routine                         *
**                 Computes the 'arctangent' for the given value          *
**                 (return value in radians)                              *
**	           argument in the range [-pi/2,pi/2].                    *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias	atanl	= _atan_spf
#pragma alias	atan		= _atan_spf
#endif
#pragma alias	atanf	= _atan_spf


extern float _atanf( float );

/*
	atan makes its argument positive and
	calls the inner routine _atan.
*/
static
float
_atan_spf( float arg )
{
	if( arg > 0.0f )
		return( _atanf( arg ) );
	else
		return( -_atanf( -arg ) );
}


