/**************************************************************************
**                                                                        *
**  FILE        :  asinhg.c                                               *
**                                                                        *
**  DESCRIPTION :  The asinh() function.                                  *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * asinh(x)
 *
 * Edwards
 * See calc for extra sign stuff.
 */
extern	double		asinh(double x)
{
	int	is_neg;
	double	result;
	if (x == 0.0 || isinf(x))
	{
		return x;
	}
	is_neg = (x < 0.0);
	if (is_neg)
	{
		x = -x;
	}
	result = log(x+sqrt(x*x+1.0));
	if (is_neg)
	{
		result = -result;
	}
	return result;
}
