/**************************************************************************
**                                                                        *
**  FILE        :  acoshg.c                                               *
**                                                                        *
**  DESCRIPTION :  The acosh() function.                                  *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * acosh(x)
 *
 * Edwards
 *
 * ISO F.9.2.1 defines exceptions. These should be handled here,
 * but for now we rely on sqrt to do the right thing.
 */
extern	double		acosh(double x)
{
	if (x == 1.0)
	{
		return 0.0;
	}
#if 0
	if (x < 1.0)
	{
		// return NaN and raise invalid FP exception.
	}
	if (isinf(x))
	{
		return x;
	}
#endif
	return log(x+sqrt(x*x-1.0));
}
