/**************************************************************************
**                                                                        *
**  FILE        :  _wflsbuf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for _wflsbuf routine                       *
**                 This routine makes sure the buffering of file I/O will *
**                 work as expected. I/O to strings is not done here, but *
**                 in the routine fputwc.                                 *
**                 Returns WEOF on error.                                 *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>
#include <io.h>


#ifdef WCHAR_SUPPORT_ENABLED

wint_t	_wflsbuf( wint_t c, register FILE *fp )
{
	fp->_flag |= _IOWCHAR;	/* tell fwide() that fp is wide-oriented */
	if ( _dofls( c, fp ) == EOF )
	{
		c = WEOF;
	}
	return c;
}

#endif
