/**************************************************************************
**                                                                        *
**  FILE        :  _wfilbuf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for _wfilbuf routine                       *
**                 This routine refills the input buffer when necessary.  *
**                 Returns WEOF on error.                                 *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>
#include <io.h>


#ifdef WCHAR_SUPPORT_ENABLED

wint_t _wfilbuf(FILE *fp)
{
	int	c;

	fp->_flag |= _IOWCHAR;	/* tell fwide() that fp is wide-oriented */
	c = _dofil(fp);
	return c == EOF ? WEOF : (wint_t)c;
}

#endif
