/**************************************************************************
**                                                                        *
**  FILE        :  _wcsccmp.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for _wcscasecmp() routine                  *
**                 Compares two wide-character strings case insensitive.  *
**                 Returns : < 0  -- ws1<ws2                              *
**                           = 0  -- ws1=ws2                              *
**                           > 0  -- ws1>ws2                              *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>
#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

int
_wcscasecmp( const wchar_t * ws1, const wchar_t * ws2 )
{
	wint_t wc1, wc2;

	do
	{
		wc2 = towupper(*ws2++);
		wc1 = towupper(*ws1++);
	} while ( wc1 != L'\0' && wc1 == wc2);

	return( (int)wc1 - (int)wc2 );
}

#endif
