/**************************************************************************
**                                                                        *
**  FILE        :  _strccmp.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for _strcasecmp() routine                  *
**                 Compares two strings case insensitive.                 *
**                 Returns : < 0  -- s1<s2                                *
**                           = 0  -- s1=s2                                *
**                           > 0  -- s1>s2                                *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <string.h>
#include <ctype.h>

int
_strcasecmp( const char * s1, const char * s2 )
{
	unsigned char c1, c2;

	do
	{
		c2 = (unsigned char) toupper((unsigned char) *s2++);
		c1 = (unsigned char) toupper((unsigned char) *s1++);
	} while ( c1 != '\0' && c1 == c2);
	return ((int)c1 - (int)c2);
}
