/**************************************************************************
**                                                                        *
**  FILE        :  _sbrk.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for _sbrk()                                *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef __HEAPSIZE
# define __HEAPSIZE 1024
#endif

char	_lc_ub_heap[ __HEAPSIZE ];
char*	_lc_ue_heap = (char *)(&_lc_ub_heap + __HEAPSIZE);

static	char*	_end = _lc_ub_heap;

void*	_sbrk ( long incr )
{
	char*	old;
	char*	new;

	old = _end;
	new = old + incr;
	if	( new < _lc_ub_heap || new > _lc_ue_heap )
	{
		return (void*) -1;
	}
	_end = new;
	return old;
}
