/**************************************************************************
**                                                                        *
**  FILE        :  _issubnormalf.c                                        *
**                                                                        *
**  DESCRIPTION :  Determines if FP number is subnormal.                  *
**                 Does not test for NaN or infinity.                     *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

#ifdef	__SINGLE_FP__
#pragma alias	_issubnormal		= _issubnormal_spf
#pragma alias	_issubnormall		= _issubnormal_spf
#endif
#pragma alias	_issubnormalf		= _issubnormal_spf
static
int	_issubnormal_spf( float f )
{
	float2long_t	u;
	unsigned long	l;

	u.f	= f;
	l	= u.l;

	return GET_FLOAT_EXPONENT( l ) == 0 &&
		GET_FLOAT_MANTISSA( l );
}
