/**************************************************************************
**                                                                        *
**  FILE        :  _io_putws.c						  *
**                                                                        *
**  DESCRIPTION :  _io_getc(), _io_putc(), _io_puts(), _io_ungetc() and   *
**                 their wide character variants are wrapper functions    *
**                 which operate either on a string or call a standard    *
**                 I/O function. They are used solely by the printf/scanf *
**                 family of functions.                                   *
**                 Unless _iob.c:_iob[] is referenced, the standard I/O   *
**                 function references will turn out to be NULL pointers  *
**                 because the references are weak. This is ok because in *
**                 that case io->fp will always be NULL. Linking in       *
**                 _iob.c will automatically pull in the standard I/O     *
**                 functions.                                             *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED
#include <wchar.h>

void	_io_putws(const wchar_t *s, struct _io *io)
{
	wchar_t	wc;

	while ((wc = *s++))
	{
		_io_putwc(wc, io);
	}
}
#endif
