/**************************************************************************
**                                                                        *
**  FILE        :  string.h                                               *
**                                                                        *
**  DESCRIPTION :  Include file with prototypes of functions for          *
**                 string handling and memory checking/movement           *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _STRING_H
#define _STRING_H	1

#ifdef	__cplusplus
extern "C" {
#endif	/* defined(__cplusplus) */

#ifndef _SIZE_T_DEF
typedef	__size_t	size_t;
#define _SIZE_T_DEF	1
#endif

#ifdef	__cplusplus
#define NULL	(0)
#else	/* !defined(__cplusplus) */
#define	NULL	( 0)
#endif	/* defined(__cplusplus) */


extern __hw_or_sw__	char *  strcpy   ( char * restrict, const char * restrict );
extern __hw_or_sw__	char *  strncpy  ( char * restrict, const char * restrict, size_t );
extern __hw_or_sw__	char *  strcat   ( char * restrict, const char * restrict );
extern __hw_or_sw__	char *  strncat  ( char * restrict, const char * restrict, size_t );
extern __hw_or_sw__	char *  strchr   ( const char *, int );
extern __hw_or_sw__	char *  strrchr  ( const char *, int );
extern __hw_or_sw__	size_t  strspn   ( const char *, const char * );
extern __hw_or_sw__	size_t  strcspn  ( const char *, const char * );
extern __hw_or_sw__	char *  strpbrk  ( const char *, const char * );
extern __hw_or_sw__	char *  strstr   ( const char *, const char * );
extern __hw_or_sw__	char *  strtok   ( char * restrict, const char * restrict );
extern __hw_or_sw__	int     strcmp   ( const char *, const char * );
extern __hw_or_sw__	int     strncmp  ( const char *, const char *, size_t );
extern __hw_or_sw__	size_t  strlen   ( const char * );
extern __hw_or_sw__	void *  memcpy   ( void * restrict, const void * restrict, size_t );
extern __hw_or_sw__	void *  memmove  ( void *, const void *, size_t );
extern __hw_or_sw__	void *  memchr   ( const void *, int, size_t );
extern __hw_or_sw__	void *  memset   ( void *, int, size_t );
extern __hw_or_sw__	int     memcmp   ( const void *, const void *, size_t );
extern __hw_or_sw__	char *  strerror ( int );
extern __hw_or_sw__	int     strcoll  ( const char *, const char * );
extern __hw_or_sw__	size_t  strxfrm  ( char * restrict, const char * restrict, size_t );


#ifdef	__cplusplus
}
#endif	/* defined(__cplusplus) */

#endif  /* _STRING_H */
