/**************************************************************************
**									  *
**  FILE	:  stdlib.h						  *
**									  *
**  DESCRIPTION :  Include file with prototypes of functions for	  *
**		   numeric conversions, storage allocation and exit	  *
**									  *
**  Copyright 1996-2010 Altium BV                                         *
**									  *
**************************************************************************/

#ifndef _STDLIB_H
#define _STDLIB_H	1

#ifdef	__cplusplus
extern "C" {
#endif	/* defined(__cplusplus) */

#ifndef _SIZE_T_DEF
typedef	__size_t	size_t;
#define _SIZE_T_DEF	1
#endif

#ifdef	__cplusplus
#define NULL	(0)
#else	/* !defined(__cplusplus) */
#define	NULL	( 0)
#endif	/* defined(__cplusplus) */

#define EXIT_SUCCESS	0
#define EXIT_FAILURE	1
#define RAND_MAX	32767


typedef struct	{
			int quot;
			int rem;
		} div_t;

typedef struct	{
			long quot;
			long rem;
		} ldiv_t;

#if	__STDC_VERSION__ >= 199901L
typedef struct	{
			long long quot;
			long long rem;
		} lldiv_t;
#endif



extern __hw_or_sw__	int                     atoi     ( const char * );
extern __hw_or_sw__	long                    atol     ( const char * );
extern __hw_or_sw__	double                  atof     ( const char * );
extern __hw_or_sw__	long                    strtol   ( const char * restrict, char ** restrict, int );
extern __hw_or_sw__	unsigned long           strtoul  ( const char * restrict, char ** restrict, int );
extern __hw_or_sw__	double                  strtod   ( const char * restrict, char ** restrict );
extern __hw_or_sw__	float			strtof   ( const char * restrict, char ** restrict );
extern __hw_or_sw__	long double             strtold  ( const char * restrict, char ** restrict );
extern __hw_or_sw__	int                     abs      ( int );
extern __hw_or_sw__	long                    labs     ( long );
extern __hw_or_sw__	div_t                   div      ( int, int );
extern __hw_or_sw__	ldiv_t                  ldiv     ( long, long );
extern __hw_or_sw__	int                     rand     ( void );
extern __hw_or_sw__	void                    srand    ( unsigned int );

extern __hw_or_sw__	void *                  calloc   ( size_t, size_t ) __malloc__;
extern __hw_or_sw__	void *                  malloc   ( size_t ) __malloc__;
extern __hw_or_sw__	void *                  realloc  ( void *, size_t ) __malloc__;
extern __hw_or_sw__	void                    free     ( void * ) __malloc__;
extern __hw_or_sw__	void *                  _malloc  ( size_t ) __malloc__;
extern __hw_or_sw__	void *                  _realloc ( void *, size_t ) __malloc__;
extern __hw_or_sw__	void                    _free    ( void * ) __malloc__;
	
/* ISO C99 specific functions that are not available when the -c90 command
 * line option is used.
 */
#if	__STDC_VERSION__ >= 199901L
extern __hw_or_sw__	long long               atoll    ( const char * );
extern __hw_or_sw__	long long               strtoll  ( const char * restrict, char ** restrict, int );
extern __hw_or_sw__	unsigned long long      strtoull ( const char * restrict, char ** restrict, int );
extern __hw_or_sw__	long long               llabs    ( long long );
extern __hw_or_sw__	lldiv_t                 lldiv    ( long long, long long );
#endif


extern __hw_or_sw__	void                    exit     ( int ) __noreturn__;
extern __hw_or_sw__	void                    abort    ( void ) __noreturn__;
extern __hw_or_sw__	int                     atexit   ( void (*)(void) );
extern __hw_or_sw__	void                    _Exit    ( int ) __noreturn__;

extern __hw_or_sw__	char *                  getenv   ( const char * );
extern __hw_or_sw__	int                     system   ( const char * );

extern __hw_or_sw__	void *			bsearch  ( const void *, const void *, size_t, size_t,
					   int (*)( const void *, const void * ) );
extern __hw_or_sw__	void			qsort    ( void *, size_t, size_t,
					   int (*)( const void *, const void * ) );
    
#ifndef _WCHAR_T
typedef	__wchar_t	wchar_t;
#define _WCHAR_T	1
#endif

#define MB_CUR_MAX	(1)

extern __hw_or_sw__	int			mblen    ( const char *, size_t );
extern __hw_or_sw__	int			mbtowc   ( wchar_t * restrict, const char * restrict, size_t );
extern __hw_or_sw__	int			wctomb   ( char *, wchar_t );
extern __hw_or_sw__	size_t			mbstowcs ( wchar_t * restrict, const char * restrict, size_t );
extern __hw_or_sw__	size_t			wcstombs ( char * restrict, const wchar_t * restrict, size_t );


#ifdef	__cplusplus
}
#endif	/* defined(__cplusplus) */

#endif	/* _STDLIB_H */
