#ifdef	__INTEGER_16BIT__

/* 16 bit integers */

/**************************************************************************
**                                                                        *
**  FILE        :  stdint.h                                               *
**                                                                        *
**  DESCRIPTION :  Integer Types                                          *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _STDINT_H
#define _STDINT_H	1

#ifdef	__cplusplus
extern "C" {
#endif	/* defined(__cplusplus) */

/*
 * 7.18.1.1 Exact-width integer types
 */
typedef	signed   char     	int8_t;
typedef	unsigned char     	uint8_t;
typedef	signed   short    	int16_t;
typedef	unsigned short    	uint16_t;
typedef	signed   long     	int32_t;
typedef	unsigned long     	uint32_t;
typedef	signed   long long	int64_t;
typedef	unsigned long long	uint64_t;

/*
 * 7.18.1.2 Minimum-width integer types
 */
typedef	signed   char     	int_least8_t;
typedef	unsigned char     	uint_least8_t;
typedef	signed   short    	int_least16_t;
typedef	unsigned short    	uint_least16_t;
typedef	signed   long     	int_least32_t;
typedef	unsigned long     	uint_least32_t;
typedef	signed   long long	int_least64_t;
typedef	unsigned long long	uint_least64_t;

/*
 * 7.18.1.3 Fastest minimum-width integer types
 */
typedef	signed   char     	int_fast8_t;
typedef	unsigned char     	uint_fast8_t;
typedef	signed   short    	int_fast16_t;
typedef	unsigned short    	uint_fast16_t;
typedef	signed   long     	int_fast32_t;
typedef	unsigned long     	uint_fast32_t;
typedef	signed   long long	int_fast64_t;
typedef	unsigned long long	uint_fast64_t;

/*
 * 7.18.1.4 Integer types capable of holding object pointers
 */
typedef	signed   long		intptr_t;
typedef	unsigned long		uintptr_t;

/*
 * 7.18.1.5 Greatest-width integer types
 */
typedef	signed   long long	intmax_t;
typedef	unsigned long long	uintmax_t;

#if ! defined __cplusplus || defined __STDC_LIMIT_MACROS

/*
 * 7.18.2.1 Limits of exact-width integer types
 */
#define	INT8_MIN        	(-INT8_MAX-1)
#define	INT8_MAX        	(0x7f)
#define	UINT8_MAX       	(0xffU)

#define	INT16_MIN        	(-INT16_MAX-1)
#define	INT16_MAX        	(0x7fff)
#define	UINT16_MAX       	(0xffffU)

#define	INT32_MIN        	(-INT32_MAX-1)
#define	INT32_MAX        	(0x7fffffffL)
#define	UINT32_MAX       	(0xffffffffUL)

#define	INT64_MIN        	(-INT64_MAX-1)
#define	INT64_MAX        	(0x7fffffffffffffffLL)
#define	UINT64_MAX       	(0xffffffffffffffffULL)

/*
 * 7.18.2.2 Limits of minimum-width integer types
 */
#define	INT_LEAST8_MIN        	(-INT_LEAST8_MAX-1)
#define	INT_LEAST8_MAX        	(0x7f)
#define	UINT_LEAST8_MAX       	(0xffU)

#define	INT_LEAST16_MIN        	(-INT_LEAST16_MAX-1)
#define	INT_LEAST16_MAX        	(0x7fff)
#define	UINT_LEAST16_MAX       	(0xffffU)

#define	INT_LEAST32_MIN        	(-INT_LEAST32_MAX-1)
#define	INT_LEAST32_MAX        	(0x7fffffffL)
#define	UINT_LEAST32_MAX       	(0xffffffffUL)

#define	INT_LEAST64_MIN        	(-INT_LEAST64_MAX-1)
#define	INT_LEAST64_MAX        	(0x7fffffffffffffffLL)
#define	UINT_LEAST64_MAX       	(0xffffffffffffffffULL)

/*
 * 7.18.2.3 Limits of fastest minimum-width integer types
 */
#define	INT_FAST8_MIN        	(-INT_FAST8_MAX-1)
#define	INT_FAST8_MAX        	(0x7f)
#define	UINT_FAST8_MAX       	(0xffU)

#define	INT_FAST16_MIN        	(-INT_FAST16_MAX-1)
#define	INT_FAST16_MAX        	(0x7fff)
#define	UINT_FAST16_MAX       	(0xffffU)

#define	INT_FAST32_MIN        	(-INT_FAST32_MAX-1)
#define	INT_FAST32_MAX        	(0x7fffffffL)
#define	UINT_FAST32_MAX       	(0xffffffffUL)

#define	INT_FAST64_MIN        	(-INT_FAST64_MAX-1)
#define	INT_FAST64_MAX        	(0x7fffffffffffffffLL)
#define	UINT_FAST64_MAX       	(0xffffffffffffffffULL)

/*
 * 7.18.2.4 Limits of integer types capable of holding object pointers
 */
#define	INTPTR_MIN		(INT32_MIN)
#define	INTPTR_MAX		(INT32_MAX)
#define	UINTPTR_MAX		(UINT32_MAX)

/*
 * 7.18.2.5 Limits of greatest-width integer types
 */
#define	INTMAX_MIN		(INT64_MIN)
#define	INTMAX_MAX		(INT64_MAX)
#define	UINTMAX_MAX		(UINT64_MAX)

/*
 * 7.18.3 Limits of other integer types
 */
#define	PTRDIFF_MIN		(__PTRDIFF_MIN)
#define	PTRDIFF_MAX		(__PTRDIFF_MAX)

#define	SIG_ATOMIC_MIN		(INT16_MIN)
#define	SIG_ATOMIC_MAX		(INT16_MAX)

#define	SIZE_MAX		(__SIZE_MAX)

#ifndef	WCHAR_MIN
#define	WCHAR_MIN		(__WCHAR_MIN)
#endif
#ifndef	WCHAR_MAX
#define	WCHAR_MAX		(__WCHAR_MAX)
#endif

#define	WINT_MIN		(0)
#define	WINT_MAX		(UINT16_MAX)

#endif /* ! defined __cplusplus || defined __STDC_LIMIT_MACROS */

#if ! defined __cplusplus || defined __STDC_CONSTANT_MACROS

/*
 * 7.18.4.1 Macros for minimum-width integer constants
 */
#define	INT8_C(value)		(value      )
#define	UINT8_C(value)		(value ## U )
#define	INT16_C(value)		(value      )
#define	UINT16_C(value)		(value ## U )
#define	INT32_C(value)		(value      ##L)
#define	UINT32_C(value)		(value ## U ##L)
#define	INT64_C(value)		(value      ##LL)
#define	UINT64_C(value)		(value ## U ##LL)

/*
 * 7.18.4.2 Macros for greatest-width integer constants
 */
#define	INTMAX_C(value)		(value      ##LL)
#define	UINTMAX_C(value)	(value ## U ##LL)

#endif /* ! defined __cplusplus || defined __STDC_CONSTANT_MACROS */

#ifdef	__cplusplus
}
#endif	/* defined(__cplusplus) */

#endif	/* _STDINT_H */

#else	/* __INTEGER_16BIT__ */

/* 32 bit integers */

/**************************************************************************
**                                                                        *
**  FILE        :  stdint.h                                               *
**                                                                        *
**  DESCRIPTION :  Integer Types                                          *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _STDINT_H
#define _STDINT_H	1

#ifdef	__cplusplus
extern "C" {
#endif	/* defined(__cplusplus) */

/*
 * 7.18.1.1 Exact-width integer types
 */
typedef	signed   char     	int8_t;
typedef	unsigned char     	uint8_t;
typedef	signed   short    	int16_t;
typedef	unsigned short    	uint16_t;
typedef	signed   int      	int32_t;
typedef	unsigned int      	uint32_t;
typedef	signed   long long	int64_t;
typedef	unsigned long long	uint64_t;

/*
 * 7.18.1.2 Minimum-width integer types
 */
typedef	signed   char     	int_least8_t;
typedef	unsigned char     	uint_least8_t;
typedef	signed   short    	int_least16_t;
typedef	unsigned short    	uint_least16_t;
typedef	signed   long     	int_least32_t;
typedef	unsigned long     	uint_least32_t;
typedef	signed   long long	int_least64_t;
typedef	unsigned long long	uint_least64_t;

/*
 * 7.18.1.3 Fastest minimum-width integer types
 */
typedef	signed   char     	int_fast8_t;
typedef	unsigned char     	uint_fast8_t;
typedef	signed   short    	int_fast16_t;
typedef	unsigned short    	uint_fast16_t;
typedef	signed   long     	int_fast32_t;
typedef	unsigned long     	uint_fast32_t;
typedef	signed   long long	int_fast64_t;
typedef	unsigned long long	uint_fast64_t;

/*
 * 7.18.1.4 Integer types capable of holding object pointers
 */
typedef	signed   long		intptr_t;
typedef	unsigned long		uintptr_t;

/*
 * 7.18.1.5 Greatest-width integer types
 */
typedef	signed   long long	intmax_t;
typedef	unsigned long long	uintmax_t;

#if ! defined __cplusplus || defined __STDC_LIMIT_MACROS

/*
 * 7.18.2.1 Limits of exact-width integer types
 */
#define	INT8_MIN        	(-INT8_MAX-1)
#define	INT8_MAX        	(0x7f)
#define	UINT8_MAX       	(0xffU)

#define	INT16_MIN        	(-INT16_MAX-1)
#define	INT16_MAX        	(0x7fff)
#define	UINT16_MAX       	(0xffffU)

#define	INT32_MIN        	(-INT32_MAX-1)
#define	INT32_MAX        	(0x7fffffff)
#define	UINT32_MAX       	(0xffffffffU)

#define	INT64_MIN        	(-INT64_MAX-1)
#define	INT64_MAX        	(0x7fffffffffffffffLL)
#define	UINT64_MAX       	(0xffffffffffffffffULL)

/*
 * 7.18.2.2 Limits of minimum-width integer types
 */
#define	INT_LEAST8_MIN        	(-INT_LEAST8_MAX-1)
#define	INT_LEAST8_MAX        	(0x7f)
#define	UINT_LEAST8_MAX       	(0xffU)

#define	INT_LEAST16_MIN        	(-INT_LEAST16_MAX-1)
#define	INT_LEAST16_MAX        	(0x7fff)
#define	UINT_LEAST16_MAX       	(0xffffU)

#define	INT_LEAST32_MIN        	(-INT_LEAST32_MAX-1)
#define	INT_LEAST32_MAX        	(0x7fffffff)
#define	UINT_LEAST32_MAX       	(0xffffffffU)

#define	INT_LEAST64_MIN        	(-INT_LEAST64_MAX-1)
#define	INT_LEAST64_MAX        	(0x7fffffffffffffffLL)
#define	UINT_LEAST64_MAX       	(0xffffffffffffffffULL)

/*
 * 7.18.2.3 Limits of fastest minimum-width integer types
 */
#define	INT_FAST8_MIN        	(-INT_FAST8_MAX-1)
#define	INT_FAST8_MAX        	(0x7f)
#define	UINT_FAST8_MAX       	(0xffU)

#define	INT_FAST16_MIN        	(-INT_FAST16_MAX-1)
#define	INT_FAST16_MAX        	(0x7fff)
#define	UINT_FAST16_MAX       	(0xffffU)

#define	INT_FAST32_MIN        	(-INT_FAST32_MAX-1)
#define	INT_FAST32_MAX        	(0x7fffffff)
#define	UINT_FAST32_MAX       	(0xffffffffU)

#define	INT_FAST64_MIN        	(-INT_FAST64_MAX-1)
#define	INT_FAST64_MAX        	(0x7fffffffffffffffLL)
#define	UINT_FAST64_MAX       	(0xffffffffffffffffULL)

/*
 * 7.18.2.4 Limits of integer types capable of holding object pointers
 */
#define	INTPTR_MIN		(INT32_MIN)
#define	INTPTR_MAX		(INT32_MAX)
#define	UINTPTR_MAX		(UINT32_MAX)

/*
 * 7.18.2.5 Limits of greatest-width integer types
 */
#define	INTMAX_MIN		(INT64_MIN)
#define	INTMAX_MAX		(INT64_MAX)
#define	UINTMAX_MAX		(UINT64_MAX)

/*
 * 7.18.3 Limits of other integer types
 */
#define	PTRDIFF_MIN		(__PTRDIFF_MIN)
#define	PTRDIFF_MAX		(__PTRDIFF_MAX)

#define	SIG_ATOMIC_MIN		(INT32_MIN)
#define	SIG_ATOMIC_MAX		(INT32_MAX)

#define	SIZE_MAX		(__SIZE_MAX)

#ifndef	WCHAR_MIN
#define	WCHAR_MIN		(__WCHAR_MIN)
#endif
#ifndef	WCHAR_MAX
#define	WCHAR_MAX		(__WCHAR_MAX)
#endif

#define	WINT_MIN		(0)
#define	WINT_MAX		(UINT32_MAX)

#endif /* ! defined __cplusplus || defined __STDC_LIMIT_MACROS */

#if ! defined __cplusplus || defined __STDC_CONSTANT_MACROS

/*
 * 7.18.4.1 Macros for minimum-width integer constants
 */
#define	INT8_C(value)		(value      )
#define	UINT8_C(value)		(value ## U )
#define	INT16_C(value)		(value      )
#define	UINT16_C(value)		(value ## U )
#define	INT32_C(value)		(value      )
#define	UINT32_C(value)		(value ## U )
#define	INT64_C(value)		(value      ##LL)
#define	UINT64_C(value)		(value ## U ##LL)

/*
 * 7.18.4.2 Macros for greatest-width integer constants
 */
#define	INTMAX_C(value)		(value      ##LL)
#define	UINTMAX_C(value)	(value ## U ##LL)

#endif /* ! defined __cplusplus || defined __STDC_CONSTANT_MACROS */

#ifdef	__cplusplus
}
#endif	/* defined(__cplusplus) */

#endif	/* _STDINT_H */

#endif	/* __INTEGER_16BIT__ */

/**************************************************************************/
/* CHC Extended Integer Types */

#ifndef _STDCHC_H
#define _STDCHC_H	1

#ifdef	__cplusplus
extern "C" {
#endif	/* defined(__cplusplus) */

	
/*
 * 7.18.1.1 Exact-width CHC extension integer types
 */
typedef  __int1_t	 int1_t;
typedef __uint1_t	uint1_t;
typedef  __int2_t	 int2_t;
typedef __uint2_t	uint2_t;
typedef  __int3_t	 int3_t;
typedef __uint3_t	uint3_t;
typedef  __int4_t	 int4_t;
typedef __uint4_t	uint4_t;
typedef  __int5_t	 int5_t;
typedef __uint5_t	uint5_t;
typedef  __int6_t	 int6_t;
typedef __uint6_t	uint6_t;
typedef  __int7_t	 int7_t;
typedef __uint7_t	uint7_t;
typedef  __int9_t	 int9_t;
typedef __uint9_t	uint9_t;
typedef  __int10_t	 int10_t;
typedef __uint10_t	uint10_t;
typedef  __int11_t	 int11_t;
typedef __uint11_t	uint11_t;
typedef  __int12_t	 int12_t;
typedef __uint12_t	uint12_t;
typedef  __int13_t	 int13_t;
typedef __uint13_t	uint13_t;
typedef  __int14_t	 int14_t;
typedef __uint14_t	uint14_t;
typedef  __int15_t	 int15_t;
typedef __uint15_t	uint15_t;
typedef  __int17_t	 int17_t;
typedef __uint17_t	uint17_t;
typedef  __int18_t	 int18_t;
typedef __uint18_t	uint18_t;
typedef  __int19_t	 int19_t;
typedef __uint19_t	uint19_t;
typedef  __int20_t	 int20_t;
typedef __uint20_t	uint20_t;
typedef  __int21_t	 int21_t;
typedef __uint21_t	uint21_t;
typedef  __int22_t	 int22_t;
typedef __uint22_t	uint22_t;
typedef  __int23_t	 int23_t;
typedef __uint23_t	uint23_t;
typedef  __int24_t	 int24_t;
typedef __uint24_t	uint24_t;
typedef  __int25_t	 int25_t;
typedef __uint25_t	uint25_t;
typedef  __int26_t	 int26_t;
typedef __uint26_t	uint26_t;
typedef  __int27_t	 int27_t;
typedef __uint27_t	uint27_t;
typedef  __int28_t	 int28_t;
typedef __uint28_t	uint28_t;
typedef  __int29_t	 int29_t;
typedef __uint29_t	uint29_t;
typedef  __int30_t	 int30_t;
typedef __uint30_t	uint30_t;
typedef  __int31_t	 int31_t;
typedef __uint31_t	uint31_t;
typedef  __int33_t	 int33_t;
typedef __uint33_t	uint33_t;
typedef  __int34_t	 int34_t;
typedef __uint34_t	uint34_t;
typedef  __int35_t	 int35_t;
typedef __uint35_t	uint35_t;
typedef  __int36_t	 int36_t;
typedef __uint36_t	uint36_t;
typedef  __int37_t	 int37_t;
typedef __uint37_t	uint37_t;
typedef  __int38_t	 int38_t;
typedef __uint38_t	uint38_t;
typedef  __int39_t	 int39_t;
typedef __uint39_t	uint39_t;
typedef  __int40_t	 int40_t;
typedef __uint40_t	uint40_t;
typedef  __int41_t	 int41_t;
typedef __uint41_t	uint41_t;
typedef  __int42_t	 int42_t;
typedef __uint42_t	uint42_t;
typedef  __int43_t	 int43_t;
typedef __uint43_t	uint43_t;
typedef  __int44_t	 int44_t;
typedef __uint44_t	uint44_t;
typedef  __int45_t	 int45_t;
typedef __uint45_t	uint45_t;
typedef  __int46_t	 int46_t;
typedef __uint46_t	uint46_t;
typedef  __int47_t	 int47_t;
typedef __uint47_t	uint47_t;
typedef  __int48_t	 int48_t;
typedef __uint48_t	uint48_t;
typedef  __int49_t	 int49_t;
typedef __uint49_t	uint49_t;
typedef  __int50_t	 int50_t;
typedef __uint50_t	uint50_t;
typedef  __int51_t	 int51_t;
typedef __uint51_t	uint51_t;
typedef  __int52_t	 int52_t;
typedef __uint52_t	uint52_t;
typedef  __int53_t	 int53_t;
typedef __uint53_t	uint53_t;
typedef  __int54_t	 int54_t;
typedef __uint54_t	uint54_t;
typedef  __int55_t	 int55_t;
typedef __uint55_t	uint55_t;
typedef  __int56_t	 int56_t;
typedef __uint56_t	uint56_t;
typedef  __int57_t	 int57_t;
typedef __uint57_t	uint57_t;
typedef  __int58_t	 int58_t;
typedef __uint58_t	uint58_t;
typedef  __int59_t	 int59_t;
typedef __uint59_t	uint59_t;
typedef  __int60_t	 int60_t;
typedef __uint60_t	uint60_t;
typedef  __int61_t	 int61_t;
typedef __uint61_t	uint61_t;
typedef  __int62_t	 int62_t;
typedef __uint62_t	uint62_t;
typedef  __int63_t	 int63_t;
typedef __uint63_t	uint63_t;

#if ! defined __cplusplus || defined __STDC_LIMIT_MACROS

/*
 * 7.18.2.1 Limits of exact-width CHC extensions integer types
 */
#define	INT1_MIN        	(-INT1_MAX-1)
#define	INT1_MAX        	(0x0)
#define	UINT1_MAX       	(0x1U)
#define	INT2_MIN        	(-INT2_MAX-1)
#define	INT2_MAX        	(0x1)
#define	UINT2_MAX       	(0x3U)
#define	INT3_MIN        	(-INT3_MAX-1)
#define	INT3_MAX        	(0x3)
#define	UINT3_MAX       	(0x7U)
#define	INT4_MIN        	(-INT4_MAX-1)
#define	INT4_MAX        	(0x7)
#define	UINT4_MAX       	(0xfU)
#define	INT5_MIN        	(-INT5_MAX-1)
#define	INT5_MAX        	(0xf)
#define	UINT5_MAX       	(0x1fU)
#define	INT6_MIN        	(-INT6_MAX-1)
#define	INT6_MAX        	(0x1f)
#define	UINT6_MAX       	(0x3fU)
#define	INT7_MIN        	(-INT7_MAX-1)
#define	INT7_MAX        	(0x3f)
#define	UINT7_MAX       	(0x7fU)
#define	INT9_MIN        	(-INT9_MAX-1)
#define	INT9_MAX        	(0xff)
#define	UINT9_MAX       	(0x1ffU)
#define	INT10_MIN        	(-INT10_MAX-1)
#define	INT10_MAX        	(0x1ff)
#define	UINT10_MAX       	(0x3ffU)
#define	INT11_MIN        	(-INT11_MAX-1)
#define	INT11_MAX        	(0x3ff)
#define	UINT11_MAX       	(0x7ffU)
#define	INT12_MIN        	(-INT12_MAX-1)
#define	INT12_MAX        	(0x7ff)
#define	UINT12_MAX       	(0xfffU)
#define	INT13_MIN        	(-INT13_MAX-1)
#define	INT13_MAX        	(0xfff)
#define	UINT13_MAX       	(0x1fffU)
#define	INT14_MIN        	(-INT14_MAX-1)
#define	INT14_MAX        	(0x1fff)
#define	UINT14_MAX       	(0x3fffU)
#define	INT15_MIN        	(-INT15_MAX-1)
#define	INT15_MAX        	(0x3fff)
#define	UINT15_MAX       	(0x7fffU)
#define	INT17_MIN        	(-INT17_MAX-1)
#define	INT17_MAX        	(0xffffL)
#define	UINT17_MAX       	(0x1ffffUL)
#define	INT18_MIN        	(-INT18_MAX-1)
#define	INT18_MAX        	(0x1ffffL)
#define	UINT18_MAX       	(0x3ffffUL)
#define	INT19_MIN        	(-INT19_MAX-1)
#define	INT19_MAX        	(0x3ffffL)
#define	UINT19_MAX       	(0x7ffffUL)
#define	INT20_MIN        	(-INT20_MAX-1)
#define	INT20_MAX        	(0x7ffffL)
#define	UINT20_MAX       	(0xfffffUL)
#define	INT21_MIN        	(-INT21_MAX-1)
#define	INT21_MAX        	(0xfffffL)
#define	UINT21_MAX       	(0x1fffffUL)
#define	INT22_MIN        	(-INT22_MAX-1)
#define	INT22_MAX        	(0x1fffffL)
#define	UINT22_MAX       	(0x3fffffUL)
#define	INT23_MIN        	(-INT23_MAX-1)
#define	INT23_MAX        	(0x3fffffL)
#define	UINT23_MAX       	(0x7fffffUL)
#define	INT24_MIN        	(-INT24_MAX-1)
#define	INT24_MAX        	(0x7fffffL)
#define	UINT24_MAX       	(0xffffffUL)
#define	INT25_MIN        	(-INT25_MAX-1)
#define	INT25_MAX        	(0xffffffL)
#define	UINT25_MAX       	(0x1ffffffUL)
#define	INT26_MIN        	(-INT26_MAX-1)
#define	INT26_MAX        	(0x1ffffffL)
#define	UINT26_MAX       	(0x3ffffffUL)
#define	INT27_MIN        	(-INT27_MAX-1)
#define	INT27_MAX        	(0x3ffffffL)
#define	UINT27_MAX       	(0x7ffffffUL)
#define	INT28_MIN        	(-INT28_MAX-1)
#define	INT28_MAX        	(0x7ffffffL)
#define	UINT28_MAX       	(0xfffffffUL)
#define	INT29_MIN        	(-INT29_MAX-1)
#define	INT29_MAX        	(0xfffffffL)
#define	UINT29_MAX       	(0x1fffffffUL)
#define	INT30_MIN        	(-INT30_MAX-1)
#define	INT30_MAX        	(0x1fffffffL)
#define	UINT30_MAX       	(0x3fffffffUL)
#define	INT31_MIN        	(-INT31_MAX-1)
#define	INT31_MAX        	(0x3fffffffL)
#define	UINT31_MAX       	(0x7fffffffUL)
#define	INT33_MIN        	(-INT33_MAX-1)
#define	INT33_MAX        	(0xffffffffLL)
#define	UINT33_MAX       	(0x1ffffffffULL)
#define	INT34_MIN        	(-INT34_MAX-1)
#define	INT34_MAX        	(0x1ffffffffLL)
#define	UINT34_MAX       	(0x3ffffffffULL)
#define	INT35_MIN        	(-INT35_MAX-1)
#define	INT35_MAX        	(0x3ffffffffLL)
#define	UINT35_MAX       	(0x7ffffffffULL)
#define	INT36_MIN        	(-INT36_MAX-1)
#define	INT36_MAX        	(0x7ffffffffLL)
#define	UINT36_MAX       	(0xfffffffffULL)
#define	INT37_MIN        	(-INT37_MAX-1)
#define	INT37_MAX        	(0xfffffffffLL)
#define	UINT37_MAX       	(0x1fffffffffULL)
#define	INT38_MIN        	(-INT38_MAX-1)
#define	INT38_MAX        	(0x1fffffffffLL)
#define	UINT38_MAX       	(0x3fffffffffULL)
#define	INT39_MIN        	(-INT39_MAX-1)
#define	INT39_MAX        	(0x3fffffffffLL)
#define	UINT39_MAX       	(0x7fffffffffULL)
#define	INT40_MIN        	(-INT40_MAX-1)
#define	INT40_MAX        	(0x7fffffffffLL)
#define	UINT40_MAX       	(0xffffffffffULL)
#define	INT41_MIN        	(-INT41_MAX-1)
#define	INT41_MAX        	(0xffffffffffLL)
#define	UINT41_MAX       	(0x1ffffffffffULL)
#define	INT42_MIN        	(-INT42_MAX-1)
#define	INT42_MAX        	(0x1ffffffffffLL)
#define	UINT42_MAX       	(0x3ffffffffffULL)
#define	INT43_MIN        	(-INT43_MAX-1)
#define	INT43_MAX        	(0x3ffffffffffLL)
#define	UINT43_MAX       	(0x7ffffffffffULL)
#define	INT44_MIN        	(-INT44_MAX-1)
#define	INT44_MAX        	(0x7ffffffffffLL)
#define	UINT44_MAX       	(0xfffffffffffULL)
#define	INT45_MIN        	(-INT45_MAX-1)
#define	INT45_MAX        	(0xfffffffffffLL)
#define	UINT45_MAX       	(0x1fffffffffffULL)
#define	INT46_MIN        	(-INT46_MAX-1)
#define	INT46_MAX        	(0x1fffffffffffLL)
#define	UINT46_MAX       	(0x3fffffffffffULL)
#define	INT47_MIN        	(-INT47_MAX-1)
#define	INT47_MAX        	(0x3fffffffffffLL)
#define	UINT47_MAX       	(0x7fffffffffffULL)
#define	INT48_MIN        	(-INT48_MAX-1)
#define	INT48_MAX        	(0x7fffffffffffLL)
#define	UINT48_MAX       	(0xffffffffffffULL)
#define	INT49_MIN        	(-INT49_MAX-1)
#define	INT49_MAX        	(0xffffffffffffLL)
#define	UINT49_MAX       	(0x1ffffffffffffULL)
#define	INT50_MIN        	(-INT50_MAX-1)
#define	INT50_MAX        	(0x1ffffffffffffLL)
#define	UINT50_MAX       	(0x3ffffffffffffULL)
#define	INT51_MIN        	(-INT51_MAX-1)
#define	INT51_MAX        	(0x3ffffffffffffLL)
#define	UINT51_MAX       	(0x7ffffffffffffULL)
#define	INT52_MIN        	(-INT52_MAX-1)
#define	INT52_MAX        	(0x7ffffffffffffLL)
#define	UINT52_MAX       	(0xfffffffffffffULL)
#define	INT53_MIN        	(-INT53_MAX-1)
#define	INT53_MAX        	(0xfffffffffffffLL)
#define	UINT53_MAX       	(0x1fffffffffffffULL)
#define	INT54_MIN        	(-INT54_MAX-1)
#define	INT54_MAX        	(0x1fffffffffffffLL)
#define	UINT54_MAX       	(0x3fffffffffffffULL)
#define	INT55_MIN        	(-INT55_MAX-1)
#define	INT55_MAX        	(0x3fffffffffffffLL)
#define	UINT55_MAX       	(0x7fffffffffffffULL)
#define	INT56_MIN        	(-INT56_MAX-1)
#define	INT56_MAX        	(0x7fffffffffffffLL)
#define	UINT56_MAX       	(0xffffffffffffffULL)
#define	INT57_MIN        	(-INT57_MAX-1)
#define	INT57_MAX        	(0xffffffffffffffLL)
#define	UINT57_MAX       	(0x1ffffffffffffffULL)
#define	INT58_MIN        	(-INT58_MAX-1)
#define	INT58_MAX        	(0x1ffffffffffffffLL)
#define	UINT58_MAX       	(0x3ffffffffffffffULL)
#define	INT59_MIN        	(-INT59_MAX-1)
#define	INT59_MAX        	(0x3ffffffffffffffLL)
#define	UINT59_MAX       	(0x7ffffffffffffffULL)
#define	INT60_MIN        	(-INT60_MAX-1)
#define	INT60_MAX        	(0x7ffffffffffffffLL)
#define	UINT60_MAX       	(0xfffffffffffffffULL)
#define	INT61_MIN        	(-INT61_MAX-1)
#define	INT61_MAX        	(0xfffffffffffffffLL)
#define	UINT61_MAX       	(0x1fffffffffffffffULL)
#define	INT62_MIN        	(-INT62_MAX-1)
#define	INT62_MAX        	(0x1fffffffffffffffLL)
#define	UINT62_MAX       	(0x3fffffffffffffffULL)
#define	INT63_MIN        	(-INT63_MAX-1)
#define	INT63_MAX        	(0x3fffffffffffffffLL)
#define	UINT63_MAX       	(0x7fffffffffffffffULL)

#endif /* ! defined __cplusplus || defined __STDC_LIMIT_MACROS */

#ifdef	__cplusplus
}
#endif	/* defined(__cplusplus) */

#endif	/* _STDCHC_H */

