/**************************************************************************
**                                                                        *
**  FILE        :  stdarg.h                                               *
**                                                                        *
**  DESCRIPTION :  Include file with prototypes and macros for usage with *
**                 variable argument lists                                *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _STDARG_H
#define _STDARG_H

/* For 32-bit sized integers, objects are always aligned at 32 bits,
 * including the pointer ap.
 *
 * For 16-bit sized integers, we can have both 16 and 32 bit sized objects,
 * and we have to align on the fly based on the object size.
 */

typedef __mem0 char * va_list;

#define	va_start(ap,last)	(ap = __dotdotdot__())
#define	__va_alignmask(type)	(sizeof(int)==4 ? 0 : (sizeof(type) < 4u ? sizeof(type)-1u : 3u ))
#define	__va_align(ap,type)	((unsigned long)(ap) & __va_alignmask(type))
#define	va_arg(ap,type)   	(*((((type *) (ap += __va_align(ap,type) + sizeof(type)))) - 1u ))
#define	va_end(ap)        	((void) 0)  
#define	va_copy(dest,src) 	((dest) = (src))

#endif  /* _STDARG_H */
