/**************************************************************************
**                                                                        *
**  FILE        :  math.h                                                 *
**                                                                        *
**  DESCRIPTION :  Include file with prototypes for mathematical          *
**                 functions                                              *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef	_MATH_H
#define	_MATH_H	1


#ifdef	__SINGLE_FP__
#   define	HUGE_VAL	(3.40282347E+38F)		/* DBL_MAX  */
#   define	HUGE_VALF	(HUGE_VAL)			/* FLT_MAX  */
#   define	HUGE_VALL	(HUGE_VAL)			/* LDBL_MAX */
#else
#   define	HUGE_VAL	(1.7976931348623157E+308)	/* DBL_MAX  */
#   define	HUGE_VALF	(3.40282347E+38F)		/* FLT_MAX  */
#   define	HUGE_VALL	(HUGE_VAL)			/* LDBL_MAX */
#endif

#ifndef	FLT_EVAL_METHOD
#   define	FLT_EVAL_METHOD	(0)
#endif

#if	FLT_EVAL_METHOD == 0
typedef	float		float_t;
typedef	double		double_t;
#elif	FLT_EVAL_METHOD == 1
typedef	double		float_t;
typedef	double		double_t;
#elif	FLT_EVAL_METHOD == 2
typedef	long double	float_t;
typedef	long double	double_t;
#else
#   error unsupported floating point evaluation method
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern __hw_or_sw__	double		sin		( double );
extern __hw_or_sw__	float		sinf		( float );
extern __hw_or_sw__	long double	sinl		( long double );
extern __hw_or_sw__	double		cos		( double );
extern __hw_or_sw__	float		cosf		( float );
extern __hw_or_sw__	long double	cosl		( long double );
extern __hw_or_sw__	double		tan		( double );
extern __hw_or_sw__	float		tanf		( float );
extern __hw_or_sw__	long double	tanl		( long double );
extern __hw_or_sw__	double		asin		( double );
extern __hw_or_sw__	float		asinf		( float );
extern __hw_or_sw__	long double	asinl		( long double );
extern __hw_or_sw__	double		acos		( double );
extern __hw_or_sw__	float		acosf		( float );
extern __hw_or_sw__	long double	acosl		( long double );
extern __hw_or_sw__	double		atan		( double );
extern __hw_or_sw__	float		atanf		( float );
extern __hw_or_sw__	long double	atanl		( long double );
extern __hw_or_sw__	double		atan2		( double, double );
extern __hw_or_sw__	float		atan2f		( float, float );
extern __hw_or_sw__	long double	atan2l		( long double, long double );
extern __hw_or_sw__	double		sinh		( double );
extern __hw_or_sw__	float		sinhf		( float );
extern __hw_or_sw__	long double	sinhl		( long double );
extern __hw_or_sw__	double		cosh		( double );
extern __hw_or_sw__	float		coshf		( float );
extern __hw_or_sw__	long double	coshl		( long double );
extern __hw_or_sw__	double		tanh		( double );
extern __hw_or_sw__	float		tanhf		( float );
extern __hw_or_sw__	long double	tanhl		( long double );
extern __hw_or_sw__	double		asinh		( double );
extern __hw_or_sw__	float		asinhf		( float );
extern __hw_or_sw__	long double	asinhl		( long double );
extern __hw_or_sw__	double		acosh		( double );
extern __hw_or_sw__	float		acoshf		( float );
extern __hw_or_sw__	long double	acoshl		( long double );
extern __hw_or_sw__	double		atanh		( double );
extern __hw_or_sw__	float		atanhf		( float );
extern __hw_or_sw__	long double	atanhl		( long double );
extern __hw_or_sw__	double		exp		( double );
extern __hw_or_sw__	float		expf		( float );
extern __hw_or_sw__	long double	expl		( long double );
extern __hw_or_sw__	double		exp2		( double );
extern __hw_or_sw__	float		exp2f		( float );
extern __hw_or_sw__	long double	exp2l		( long double );
extern __hw_or_sw__	double		expm1		( double );
extern __hw_or_sw__	float		expm1f		( float );
extern __hw_or_sw__	long double	expm1l		( long double );
extern __hw_or_sw__	double		frexp		( double, int * );
extern __hw_or_sw__	float		frexpf		( float, int * );
extern __hw_or_sw__	long double	frexpl		( long double, int * );
extern __hw_or_sw__	int		ilogb		( double );
extern __hw_or_sw__	int		ilogbf		( float );
extern __hw_or_sw__	int		ilogbl		( long double );
extern __hw_or_sw__	double		ldexp		( double, int );
extern __hw_or_sw__	float		ldexpf		( float, int );
extern __hw_or_sw__	long double	ldexpl		( long double, int );
extern __hw_or_sw__	double		log		( double );
extern __hw_or_sw__	float		logf		( float );
extern __hw_or_sw__	long double	logl		( long double );
extern __hw_or_sw__	double		log10		( double );
extern __hw_or_sw__	float		log10f		( float );
extern __hw_or_sw__	long double	log10l		( long double );
extern __hw_or_sw__	double		log1p		( double );
extern __hw_or_sw__	float		log1pf		( float );
extern __hw_or_sw__	long double	log1pl		( long double );
extern __hw_or_sw__	double		log2		( double );
extern __hw_or_sw__	float		log2f		( float );
extern __hw_or_sw__	long double	log2l		( long double );
extern __hw_or_sw__	double		logb		( double );
extern __hw_or_sw__	float		logbf		( float );
extern __hw_or_sw__	long double	logbl		( long double );
extern __hw_or_sw__	double		modf		( double, double * );
extern __hw_or_sw__	float		modff		( float, float * );
extern __hw_or_sw__	long double	modfl		( long double, long double * );
#if	__STDC_VERSION__ >= 199901L
extern __hw_or_sw__	double		scalbn		( double, int );
extern __hw_or_sw__	float		scalbnf		( float, int );
extern __hw_or_sw__	long double	scalbnl		( long double, int );
extern __hw_or_sw__	double		scalbln		( double, long );
extern __hw_or_sw__	float		scalblnf	( float, long );
extern __hw_or_sw__	long double	scalblnl	( long double, long );
#endif	/* __STDC_VERSION__ >= 199901L */
extern __hw_or_sw__	double		cbrt		( double );
extern __hw_or_sw__	float		cbrtf		( float );
extern __hw_or_sw__	long double	cbrtl		( long double );
extern __hw_or_sw__	double		fabs		( double );
extern __hw_or_sw__	float		fabsf		( float );
extern __hw_or_sw__	long double	fabsl		( long double );
extern __hw_or_sw__	double		hypot		( double, double );
extern __hw_or_sw__	float		hypotf		( float, float );
extern __hw_or_sw__	long double	hypotl		( long double, long double );
extern __hw_or_sw__	double		pow		( double, double );
extern __hw_or_sw__	float		powf		( float, float );
extern __hw_or_sw__	long double	powl		( long double, long double );
extern __hw_or_sw__	double		sqrt		( double );
extern __hw_or_sw__	float		sqrtf		( float );
extern __hw_or_sw__	long double	sqrtl		( long double );
extern __hw_or_sw__	double		erf		( double );
extern __hw_or_sw__	float		erff		( float );
extern __hw_or_sw__	long double	erfl		( long double );
extern __hw_or_sw__	double		erfc		( double );
extern __hw_or_sw__	float		erfcf		( float );
extern __hw_or_sw__	long double	erfcl		( long double );
extern __hw_or_sw__	double		lgamma		( double );
extern __hw_or_sw__	float		lgammaf		( float );
extern __hw_or_sw__	long double	lgammal		( long double );
extern __hw_or_sw__	double		tgamma		( double );
extern __hw_or_sw__	float		tgammaf		( float );
extern __hw_or_sw__	long double	tgammal		( long double );
extern __hw_or_sw__	double		ceil		( double );
extern __hw_or_sw__	float		ceilf		( float );
extern __hw_or_sw__	long double	ceill		( long double );
extern __hw_or_sw__	double		floor		( double );
extern __hw_or_sw__	float		floorf		( float );
extern __hw_or_sw__	long double	floorl		( long double );
extern __hw_or_sw__	double		nearbyint	( double );
extern __hw_or_sw__	float		nearbyintf	( float );
extern __hw_or_sw__	long double	nearbyintl	( long double );
extern __hw_or_sw__	double		rint		( double );
extern __hw_or_sw__	float		rintf		( float );
extern __hw_or_sw__	long double	rintl		( long double );
extern __hw_or_sw__	long		lrint		( double );
extern __hw_or_sw__	long		lrintf		( float );
extern __hw_or_sw__	long		lrintl		( long double );
#if     __STDC_VERSION__ >= 199901L
extern __hw_or_sw__	long long	llrint		( double );
extern __hw_or_sw__	long long	llrintf		( float );
extern __hw_or_sw__	long long	llrintl		( long double );
#endif	/* __STDC_VERSION__ >= 199901L */
extern __hw_or_sw__	double		round		( double );
extern __hw_or_sw__	float		roundf		( float );
extern __hw_or_sw__	long double	roundl		( long double );
extern __hw_or_sw__	long		lround		( double );
extern __hw_or_sw__	long		lroundf		( float );
extern __hw_or_sw__	long		lroundl		( long double );
#if     __STDC_VERSION__ >= 199901L
extern __hw_or_sw__	long long	llround		( double );
extern __hw_or_sw__	long long	llroundf	( float );
extern __hw_or_sw__	long long	llroundl	( long double );
#endif	/* __STDC_VERSION__ >= 199901L */
extern __hw_or_sw__	double		trunc		( double );
extern __hw_or_sw__	float		truncf		( float );
extern __hw_or_sw__	long double	truncl		( long double );
extern __hw_or_sw__	double		fmod		( double, double );
extern __hw_or_sw__	float		fmodf		( float, float );
extern __hw_or_sw__	long double	fmodl		( long double, long double );
extern __hw_or_sw__	double		remainder	( double, double );
extern __hw_or_sw__	float		remainderf	( float, float );
extern __hw_or_sw__	long double	remainderl	( long double, long double );
extern __hw_or_sw__	double		remquo		( double, double, int * );
extern __hw_or_sw__	float		remquof		( float, float, int * );
extern __hw_or_sw__	long double	remquol		( long double, long double, int * );
#if     __STDC_VERSION__ >= 199901L
extern __hw_or_sw__	double		copysign	( double, double );
extern __hw_or_sw__	float		copysignf	( float, float );
extern __hw_or_sw__	long double	copysignl	( long double, long double );
#endif	/* __STDC_VERSION__ >= 199901L */
extern __hw_or_sw__	double		nan		( const char * );
extern __hw_or_sw__	float		nanf		( const char * );
extern __hw_or_sw__	long double	nanl		( const char * );
extern __hw_or_sw__	double		nextafter	( double, double );
extern __hw_or_sw__	float		nextafterf	( float, float );
extern __hw_or_sw__	long double	nextafterl	( long double, long double );
extern __hw_or_sw__	double		nexttoward	( double, long double );
extern __hw_or_sw__	float		nexttowardf	( float, long double );
extern __hw_or_sw__	long double	nexttowardl	( long double, long double );
extern __hw_or_sw__	double		fdim		( double, double );
extern __hw_or_sw__	float		fdimf		( float, float );
extern __hw_or_sw__	long double	fdiml		( long double, long double );
extern __hw_or_sw__	double		fmax		( double, double );
extern __hw_or_sw__	float		fmaxf		( float, float );
extern __hw_or_sw__	long double	fmaxl		( long double, long double );
extern __hw_or_sw__	double		fmin		( double, double );
extern __hw_or_sw__	float		fminf		( float, float );
extern __hw_or_sw__	long double	fminl		( long double, long double );
extern __hw_or_sw__	double		fma		( double, double, double );
extern __hw_or_sw__	float		fmaf		( float, float, float );
extern __hw_or_sw__	long double	fmal		( long double, long double, long double );
#if	__STDC_VERSION__ >= 199901L	
extern __hw_or_sw__	int		_fpclassify		( double );
extern __hw_or_sw__	int		_fpclassifyf		( float );
extern __hw_or_sw__	int		_fpclassifyl		( long double );
extern __hw_or_sw__	int		_isfinite		( double );
extern __hw_or_sw__	int		_isfinitef		( float );
extern __hw_or_sw__	int		_isfinitel		( long double );
extern __hw_or_sw__	int		_isinf			( double );
extern __hw_or_sw__	int		_isinff			( float );
extern __hw_or_sw__	int		_isinfl			( long double );
extern __hw_or_sw__	int		_isnan			( double );
extern __hw_or_sw__	int		_isnanf			( float );
extern __hw_or_sw__	int		_isnanl			( long double );
extern __hw_or_sw__	int		_isnormal		( double );
extern __hw_or_sw__	int		_isnormalf		( float );
extern __hw_or_sw__	int		_isnormall		( long double );
extern __hw_or_sw__	int		_signbit		( double );
extern __hw_or_sw__	int		_signbitf		( float );
extern __hw_or_sw__	int		_signbitl		( long double );

enum
{
	FP_INFINITE,
	FP_NAN,
	FP_NORMAL,
	FP_SUBNORMAL,
	FP_ZERO
};
#define	fpclassify(x)		(__tgmath__fpclassify__1(x))
#define	isfinite(x)		(__tgmath__isfinite__1(x))
#define	isinf(x)		(__tgmath__isinf__1(x))
#define	isnan(x)		(__tgmath__isnan__1(x))
#define	isnormal(x)		(__tgmath__isnormal__1(x))
#define	signbit(x)		(__tgmath__signbit__1(x))
extern __hw_or_sw__	int		_isgreater		( double, double );
extern __hw_or_sw__	int		_isgreaterf		( float, float );
extern __hw_or_sw__	int		_isgreaterl		( long double, long double );
extern __hw_or_sw__	int		_isgreaterequal		( double, double );
extern __hw_or_sw__	int		_isgreaterequalf	( float, float );
extern __hw_or_sw__	int		_isgreaterequall	( long double, long double );
extern __hw_or_sw__	int		_isless			( double, double );
extern __hw_or_sw__	int		_islessf		( float, float );
extern __hw_or_sw__	int		_islessl		( long double, long double );
extern __hw_or_sw__	int		_islessequal		( double, double );
extern __hw_or_sw__	int		_islessequalf		( float, float );
extern __hw_or_sw__	int		_islessequall		( long double, long double );
extern __hw_or_sw__	int		_islessgreater		( double, double );
extern __hw_or_sw__	int		_islessgreaterf		( float, float );
extern __hw_or_sw__	int		_islessgreaterl		( long double, long double );
extern __hw_or_sw__	int		_isunordered		( double, double );
extern __hw_or_sw__	int		_isunorderedf		( float, float );
extern __hw_or_sw__	int		_isunorderedl		( long double, long double );
#define	isgreater(x,y)		(__tgmath__isgreater__2(x,y))
#define	isgreaterequal(x,y)	(__tgmath__isgreaterequal__2(x,y))
#define	isless(x,y)		(__tgmath__isless__2(x,y))
#define	islessequal(x,y)	(__tgmath__islessequal__2(x,y))
#define	islessgreater(x,y)	(__tgmath__islessgreater__2(x,y))
#define	isunordered(x,y)	(__tgmath__isunordered__2(x,y))
#endif	/* __STDC_VERSION__ >= 199901L */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* _MATH_H */
