/**************************************************************************
**                                                                        *
**  FILE        :  complex.h                                              *
**                                                                        *
**  DESCRIPTION :  Complex arithmetic                                     *
**                                                                        *
**  Copyright 1996-2010 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _COMPLEX_H
#define _COMPLEX_H	1

#ifdef	__cplusplus
extern "C" {
#endif	/* defined(__cplusplus) */


/*
 * Several macros which are used to address the real and
 * imaginary pars of a complex.
 * The ISO standard specifies that a complex has the same
 * size and alignment as as a float[2], double[2] or
 * long double[2] array.
 * The first part is the real part, the second part is
 * the imaginary part.
 *
 * This might also have been done using structs, which would
 * have made things more readable. However, it might be
 * possible that a struct has a different alignment and/or
 * size from such an array.
 */

#define __cd_r(z)		(((double *)&(z))[0])
#define __cd_i(z)		(((double *)&(z))[1])
#define __cf_r(z)		(((float *)&(z))[0])
#define __cf_i(z)		(((float *)&(z))[1])
#define __cld_r(z)		(((long double *)&(z))[0])
#define __cld_i(z)		(((long double *)&(z))[1])

/*
 * Macros for the imaginary unit for all types.
 */
#define	__imag(c)	(_Pragma("extension isuffix") c ## i _Pragma("extension isuffix restore"))

#pragma nomisrac 19.4
#define	complex		_Complex
#define imaginary	_Imaginary
#pragma nomisrac restore
#define _Imaginary_I	(__imag(1.0f))
#define	_Complex_I	((const _Complex float) _Imaginary_I)
#define	I		(_Imaginary_I)

#define __CFI		((const _Complex float)       __imag(1.0f))
#define __CDI		((const _Complex double)      __imag(1.0))
#define __CLDI		((const _Complex long double) __imag(1.0l))

extern __hw_or_sw__	double complex		cacos(double complex z);
extern __hw_or_sw__	float complex		cacosf(float complex z);
extern __hw_or_sw__	long double complex	cacosl(long double complex z);
extern __hw_or_sw__	double complex		casin(double complex z);
extern __hw_or_sw__	float complex		casinf(float complex z);
extern __hw_or_sw__	long double complex	casinl(long double complex z);
extern __hw_or_sw__	double complex		catan(double complex z);
extern __hw_or_sw__	float complex		catanf(float complex z);
extern __hw_or_sw__	long double complex	catanl(long double complex z);
extern __hw_or_sw__	double complex		ccos(double complex z);
extern __hw_or_sw__	float complex		ccosf(float complex z);
extern __hw_or_sw__	long double complex	ccosl(long double complex z);
extern __hw_or_sw__	double complex		csin(double complex z);
extern __hw_or_sw__	float complex		csinf(float complex z);
extern __hw_or_sw__	long double complex	csinl(long double complex z);
extern __hw_or_sw__	double complex		ctan(double complex z);
extern __hw_or_sw__	float complex		ctanf(float complex z);
extern __hw_or_sw__	long double complex	ctanl(long double complex z);
extern __hw_or_sw__	double complex		cacosh(double complex z);
extern __hw_or_sw__	float complex		cacoshf(float complex z);
extern __hw_or_sw__	long double complex	cacoshl(long double complex z);
extern __hw_or_sw__	double complex		casinh(double complex z);
extern __hw_or_sw__	float complex		casinhf(float complex z);
extern __hw_or_sw__	long double complex	casinhl(long double complex z);
extern __hw_or_sw__	double complex		catanh(double complex z);
extern __hw_or_sw__	float complex		catanhf(float complex z);
extern __hw_or_sw__	long double complex	catanhl(long double complex z);
extern __hw_or_sw__	double complex		ccosh(double complex z);
extern __hw_or_sw__	float complex		ccoshf(float complex z);
extern __hw_or_sw__	long double complex	ccoshl(long double complex z);
extern __hw_or_sw__	double complex		csinh(double complex z);
extern __hw_or_sw__	float complex		csinhf(float complex z);
extern __hw_or_sw__	long double complex	csinhl(long double complex z);
extern __hw_or_sw__	double complex		ctanh(double complex z);
extern __hw_or_sw__	float complex		ctanhf(float complex z);
extern __hw_or_sw__	long double complex	ctanhl(long double complex z);
extern __hw_or_sw__	double complex		cexp(double complex z);
extern __hw_or_sw__	float complex		cexpf(float complex z);
extern __hw_or_sw__	long double complex	cexpl(long double complex z);
extern __hw_or_sw__	double complex		clog(double complex z);
extern __hw_or_sw__	float complex		clogf(float complex z);
extern __hw_or_sw__	long double complex	clogl(long double complex z);
extern __hw_or_sw__	double			cabs(double complex z);
extern __hw_or_sw__	float			cabsf(float complex z);
extern __hw_or_sw__	long double		cabsl(long double complex z);
extern __hw_or_sw__	double complex		cpow(double complex x, double complex y);
extern __hw_or_sw__	float complex		cpowf(float complex x, float complex y);
extern __hw_or_sw__	long double complex	cpowl(long double complex x, long double complex y);
extern __hw_or_sw__	double complex		csqrt(double complex z);
extern __hw_or_sw__	float complex		csqrtf(float complex z);
extern __hw_or_sw__	long double complex	csqrtl(long double complex z);
extern __hw_or_sw__	double			carg(double complex z);
extern __hw_or_sw__	float			cargf(float complex z);
extern __hw_or_sw__	long double		cargl(long double complex z);
extern __hw_or_sw__	double			cimag(double complex z);
extern __hw_or_sw__	float			cimagf(float complex z);
extern __hw_or_sw__	long double		cimagl(long double complex z);
extern __hw_or_sw__	double complex		conj(double complex z);
extern __hw_or_sw__	float complex		conjf(float complex z);
extern __hw_or_sw__	long double complex	conjl(long double complex z);
extern __hw_or_sw__	double complex		cproj(double complex z);
extern __hw_or_sw__	float complex		cprojf(float complex z);
extern __hw_or_sw__	long double complex	cprojl(long double complex z);
extern __hw_or_sw__	double			creal(double complex z);
extern __hw_or_sw__	float			crealf(float complex z);
extern __hw_or_sw__	long double		creall(long double complex z);

#ifdef	__cplusplus
}
#endif	/* defined(__cplusplus) */

#endif	/* _COMPLEX_H */
