#ifndef __SW_ARCH
#  define __SW_ARCH	TSK3000
#endif
#ifndef __HW_ARCH
#  define __HW_ARCH	TSKHC
#endif
#ifndef __SW_LSL
#  define __SW_LSL	"3000.lsl"
#endif
#ifndef __HW_LSL
#  define __HW_LSL	"chc.lsl"
#endif
#ifndef __SPACE
#  define __SPACE	main
#endif
#ifndef __BUS
#  define __BUS		addr_bus
#endif

#include __HW_LSL

#define __MEMORY
#define __NO_PCLSMEM
#include __SW_LSL

derivative system
{
	core sw
	{
		architecture = __SW_ARCH;
	}
	core hc
	{
		architecture = __HW_ARCH;
	}
	memory mem1
	{
		type = blockram;
		size = 4194304;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=4194304, dest=bus:hc:bus1);
	}
	memory mem2
	{
		type = blockram;
		size = 2048;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=2048, dest=bus:hc:bus2);
	}
	memory mem3
	{
		type = blockram;
		size = 2048;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=2048, dest=bus:hc:bus3);
	}
	memory mem4
	{
		type = blockram;
		size = 2048;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=2048, dest=bus:hc:bus4);
	}
	memory mem5
	{
		type = blockram;
		size = 2048;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=2048, dest=bus:hc:bus5);
	}
	memory mem6
	{
		type = blockram;
		size = 2048;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=2048, dest=bus:hc:bus6);
	}
	memory mem7
	{
		type = blockram;
		size = 2048;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=2048, dest=bus:hc:bus7);
	}
	memory mem8
	{
		type = blockram;
		size = 2048;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=2048, dest=bus:hc:bus8);
	}
	memory mem9
	{
		type = blockram;
		size = 2048;
		setuptime = 20;
		holdtime = 30;
		cycles = 1;
		readwrite_ports = 1;
		read_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=0, size=2048, dest=bus:hc:bus9);
	}

	memory mem0
	{
		type = ram;
		size = 4194303;
		setuptime = 20;
		holdtime = 30;
		cycles = -1;
		readwrite_ports = 1;
		mau = 8;
		map(src_offset=0, dest_offset=1000M, size=4194303, dest=bus:hc:wb );
		map(src_offset=0, dest_offset=1000M, size=4194303, dest=bus:sw:__BUS );
	}

	memory dummy_port_memory_1 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_1 ); }
	memory dummy_port_memory_2 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_2 ); }
	memory dummy_port_memory_3 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_3 ); }
	memory dummy_port_memory_4 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_4 ); }
	memory dummy_port_memory_5 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_5 ); }
	memory dummy_port_memory_6 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_6 ); }
	memory dummy_port_memory_7 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_7 ); }
	memory dummy_port_memory_8 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_8 ); }
	memory dummy_port_memory_9 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_9 ); }
	memory dummy_port_memory_10 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_10 ); }
	memory dummy_port_memory_11 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_11 ); }
	memory dummy_port_memory_12 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_12 ); }
	memory dummy_port_memory_13 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_13 ); }
	memory dummy_port_memory_14 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_14 ); }
	memory dummy_port_memory_15 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_15 ); }
	memory dummy_port_memory_16 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_16 ); }
	memory dummy_port_memory_17 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_17 ); }
	memory dummy_port_memory_18 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_18 ); }
	memory dummy_port_memory_19 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_19 ); }
	memory dummy_port_memory_20 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_20 ); }
	memory dummy_port_memory_21 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_21 ); }
	memory dummy_port_memory_22 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_22 ); }
	memory dummy_port_memory_23 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_23 ); }
	memory dummy_port_memory_24 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_24 ); }
	memory dummy_port_memory_25 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_25 ); }
	memory dummy_port_memory_26 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_26 ); }
	memory dummy_port_memory_27 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_27 ); }
	memory dummy_port_memory_28 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_28 ); }
	memory dummy_port_memory_29 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_29 ); }
	memory dummy_port_memory_30 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_30 ); }
	memory dummy_port_memory_31 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_31 ); }
	memory dummy_port_memory_32 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_32 ); }
	memory dummy_port_memory_33 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_33 ); }
	memory dummy_port_memory_34 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_34 ); }
	memory dummy_port_memory_35 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_35 ); }
	memory dummy_port_memory_36 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_36 ); }
	memory dummy_port_memory_37 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_37 ); }
	memory dummy_port_memory_38 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_38 ); }
	memory dummy_port_memory_39 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_39 ); }
	memory dummy_port_memory_40 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_40 ); }
	memory dummy_port_memory_41 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_41 ); }
	memory dummy_port_memory_42 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_42 ); }
	memory dummy_port_memory_43 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_43 ); }
	memory dummy_port_memory_44 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_44 ); }
	memory dummy_port_memory_45 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_45 ); }
	memory dummy_port_memory_46 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_46 ); }
	memory dummy_port_memory_47 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_47 ); }
	memory dummy_port_memory_48 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_48 ); }
	memory dummy_port_memory_49 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_49 ); }
	memory dummy_port_memory_50 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_50 ); }
	memory dummy_port_memory_51 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_51 ); }
	memory dummy_port_memory_52 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_52 ); }
	memory dummy_port_memory_53 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_53 ); }
	memory dummy_port_memory_54 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_54 ); }
	memory dummy_port_memory_55 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_55 ); }
	memory dummy_port_memory_56 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_56 ); }
	memory dummy_port_memory_57 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_57 ); }
	memory dummy_port_memory_58 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_58 ); }
	memory dummy_port_memory_59 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_59 ); }
	memory dummy_port_memory_60 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_60 ); }
	memory dummy_port_memory_61 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_61 ); }
	memory dummy_port_memory_62 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_62 ); }
	memory dummy_port_memory_63 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_63 ); }
	memory dummy_port_memory_64 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_64 ); }
	memory dummy_port_memory_65 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_65 ); }
	memory dummy_port_memory_66 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_66 ); }
	memory dummy_port_memory_67 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_67 ); }
	memory dummy_port_memory_68 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_68 ); }
	memory dummy_port_memory_69 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_69 ); }
	memory dummy_port_memory_70 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_70 ); }
	memory dummy_port_memory_71 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_71 ); }
	memory dummy_port_memory_72 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_72 ); }
	memory dummy_port_memory_73 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_73 ); }
	memory dummy_port_memory_74 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_74 ); }
	memory dummy_port_memory_75 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_75 ); }
	memory dummy_port_memory_76 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_76 ); }
	memory dummy_port_memory_77 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_77 ); }
	memory dummy_port_memory_78 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_78 ); }
	memory dummy_port_memory_79 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_79 ); }
	memory dummy_port_memory_80 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_80 ); }
	memory dummy_port_memory_81 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_81 ); }
	memory dummy_port_memory_82 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_82 ); }
	memory dummy_port_memory_83 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_83 ); }
	memory dummy_port_memory_84 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_84 ); }
	memory dummy_port_memory_85 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_85 ); }
	memory dummy_port_memory_86 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_86 ); }
	memory dummy_port_memory_87 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_87 ); }
	memory dummy_port_memory_88 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_88 ); }
	memory dummy_port_memory_89 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_89 ); }
	memory dummy_port_memory_90 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_90 ); }
	memory dummy_port_memory_91 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_91 ); }
	memory dummy_port_memory_92 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_92 ); }
	memory dummy_port_memory_93 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_93 ); }
	memory dummy_port_memory_94 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_94 ); }
	memory dummy_port_memory_95 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_95 ); }
	memory dummy_port_memory_96 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_96 ); }
	memory dummy_port_memory_97 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_97 ); }
	memory dummy_port_memory_98 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_98 ); }
	memory dummy_port_memory_99 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_99 ); }
	memory dummy_port_memory_100 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_100 ); }
	memory dummy_port_memory_101 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_101 ); }
	memory dummy_port_memory_102 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_102 ); }
	memory dummy_port_memory_103 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_103 ); }
	memory dummy_port_memory_104 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_104 ); }
	memory dummy_port_memory_105 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_105 ); }
	memory dummy_port_memory_106 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_106 ); }
	memory dummy_port_memory_107 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_107 ); }
	memory dummy_port_memory_108 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_108 ); }
	memory dummy_port_memory_109 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_109 ); }
	memory dummy_port_memory_110 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_110 ); }
	memory dummy_port_memory_111 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_111 ); }
	memory dummy_port_memory_112 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_112 ); }
	memory dummy_port_memory_113 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_113 ); }
	memory dummy_port_memory_114 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_114 ); }
	memory dummy_port_memory_115 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_115 ); }
	memory dummy_port_memory_116 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_116 ); }
	memory dummy_port_memory_117 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_117 ); }
	memory dummy_port_memory_118 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_118 ); }
	memory dummy_port_memory_119 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_119 ); }
	memory dummy_port_memory_120 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_120 ); }
	memory dummy_port_memory_121 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_121 ); }
	memory dummy_port_memory_122 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_122 ); }
	memory dummy_port_memory_123 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_123 ); }
	memory dummy_port_memory_124 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_124 ); }
	memory dummy_port_memory_125 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_125 ); }
	memory dummy_port_memory_126 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_126 ); }
	memory dummy_port_memory_127 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_127 ); }
	memory dummy_port_memory_128 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_128 ); }
	memory dummy_port_memory_129 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_129 ); }
	memory dummy_port_memory_130 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_130 ); }
	memory dummy_port_memory_131 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_131 ); }
	memory dummy_port_memory_132 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_132 ); }
	memory dummy_port_memory_133 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_133 ); }
	memory dummy_port_memory_134 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_134 ); }
	memory dummy_port_memory_135 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_135 ); }
	memory dummy_port_memory_136 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_136 ); }
	memory dummy_port_memory_137 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_137 ); }
	memory dummy_port_memory_138 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_138 ); }
	memory dummy_port_memory_139 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_139 ); }
	memory dummy_port_memory_140 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_140 ); }
	memory dummy_port_memory_141 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_141 ); }
	memory dummy_port_memory_142 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_142 ); }
	memory dummy_port_memory_143 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_143 ); }
	memory dummy_port_memory_144 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_144 ); }
	memory dummy_port_memory_145 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_145 ); }
	memory dummy_port_memory_146 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_146 ); }
	memory dummy_port_memory_147 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_147 ); }
	memory dummy_port_memory_148 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_148 ); }
	memory dummy_port_memory_149 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_149 ); }
	memory dummy_port_memory_150 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_150 ); }
	memory dummy_port_memory_151 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_151 ); }
	memory dummy_port_memory_152 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_152 ); }
	memory dummy_port_memory_153 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_153 ); }
	memory dummy_port_memory_154 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_154 ); }
	memory dummy_port_memory_155 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_155 ); }
	memory dummy_port_memory_156 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_156 ); }
	memory dummy_port_memory_157 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_157 ); }
	memory dummy_port_memory_158 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_158 ); }
	memory dummy_port_memory_159 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_159 ); }
	memory dummy_port_memory_160 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_160 ); }
	memory dummy_port_memory_161 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_161 ); }
	memory dummy_port_memory_162 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_162 ); }
	memory dummy_port_memory_163 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_163 ); }
	memory dummy_port_memory_164 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_164 ); }
	memory dummy_port_memory_165 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_165 ); }
	memory dummy_port_memory_166 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_166 ); }
	memory dummy_port_memory_167 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_167 ); }
	memory dummy_port_memory_168 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_168 ); }
	memory dummy_port_memory_169 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_169 ); }
	memory dummy_port_memory_170 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_170 ); }
	memory dummy_port_memory_171 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_171 ); }
	memory dummy_port_memory_172 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_172 ); }
	memory dummy_port_memory_173 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_173 ); }
	memory dummy_port_memory_174 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_174 ); }
	memory dummy_port_memory_175 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_175 ); }
	memory dummy_port_memory_176 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_176 ); }
	memory dummy_port_memory_177 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_177 ); }
	memory dummy_port_memory_178 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_178 ); }
	memory dummy_port_memory_179 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_179 ); }
	memory dummy_port_memory_180 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_180 ); }
	memory dummy_port_memory_181 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_181 ); }
	memory dummy_port_memory_182 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_182 ); }
	memory dummy_port_memory_183 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_183 ); }
	memory dummy_port_memory_184 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_184 ); }
	memory dummy_port_memory_185 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_185 ); }
	memory dummy_port_memory_186 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_186 ); }
	memory dummy_port_memory_187 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_187 ); }
	memory dummy_port_memory_188 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_188 ); }
	memory dummy_port_memory_189 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_189 ); }
	memory dummy_port_memory_190 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_190 ); }
	memory dummy_port_memory_191 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_191 ); }
	memory dummy_port_memory_192 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_192 ); }
	memory dummy_port_memory_193 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_193 ); }
	memory dummy_port_memory_194 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_194 ); }
	memory dummy_port_memory_195 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_195 ); }
	memory dummy_port_memory_196 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_196 ); }
	memory dummy_port_memory_197 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_197 ); }
	memory dummy_port_memory_198 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_198 ); }
	memory dummy_port_memory_199 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_199 ); }
	memory dummy_port_memory_200 {	mau = 8; type = reserved ram; size = 20k; map ( size = 20k, dest_offset = 0, dest = bus:hc:bus_port_200 ); }

#define __IROMSTART	0
#define __IROMSIZE	64k
#define __IRAMSTART	(__IROMSTART + __IROMSIZE)
#define __IRAMSIZE	512k
#define __XROMSTART	(__IRAMSTART + __IRAMSIZE)
#define __XROMSIZE	512k
#ifndef __PCLSSIZE
# define __PCLSSIZE	1k
#endif
#ifndef __PCLSADDR
# define __PCLSADDR	0xFF000000
#endif
#ifndef __PCLSPARAMS
# define __PCLSPARAMS (__PCLSADDR + 4)
#endif

	memory irom
	{
		mau = 8;
		type = rom;
		size = __IROMSIZE;
		map ( size = __IROMSIZE, dest_offset = __IROMSTART, dest = bus:sw:__BUS );
	}

	memory iram
	{
		mau = 8;
		type = ram;
		size = __IRAMSIZE;
		map ( size = __IRAMSIZE, dest_offset = __IRAMSTART, dest = bus:sw:__BUS );
	}

	memory xrom
	{
		mau = 8;
		type = rom;
		size = __XROMSIZE;
		map ( size = __XROMSIZE, dest_offset = __XROMSTART, dest = bus:sw:__BUS );
		map ( size = __XROMSIZE, dest_offset = __XROMSTART, dest = bus:hc:wb );
	}

	memory pcls
	{
		mau = 8;
		type = reserved ram;
		size = __PCLSSIZE;
		map ( size = __PCLSSIZE, dest_offset = __PCLSADDR, dest = bus:sw:__BUS );
	}


	section_layout :sw:__SPACE
	{
		group(run_addr = __PCLSADDR, ordered) select "__rtl_trigger*";
	}

	section_layout :sw:__SPACE
	{
		group(run_addr = __PCLSPARAMS, ordered) select "stack_data*";
	}

	section_layout :sw:__SPACE
	{
		group(run_addr = mem:xrom) select ".rodata*.chc_shared";
		group(run_addr = mem:mem0) select ".(data|bss)*.chc_shared";
	}

}
