##  CHC specific specification file 

# tool configuration
TARGET		= hc
SWTARGET        =
CFE		= c$(TARGET)
ASM		= as$(TARGET)
LLNG		= lk$(TARGET)
HDLHC		= hdl$(TARGET)

# output extensions
MIL_OUT		= mil
CFE_OUT		= src
ASM_OUT		= obj
LLNG_OUT	= elf
SW_QUAL         = sw.qual
SW_OBJ		= sw.obj
SW_ELF		= sw.elf
SW_MIL		= sw.mil

# default options
DEFAULT_ENDIAN_FLAG = --endianness=big
DEFAULT_LSL_FLAG = --lsl-file=solo.lsl
SYSMILLIB_NAME = libc
SYSMILLIB_16BIT_SUFFIX =
SYSMILLIB_ENDIAN_SUFFIX =

%file	*.c *.ic
{
	C_FILES = $(C_FILES) $(MATCH)
}

%file	*.mil
{
	MIL_FILES = $(MIL_FILES) $(MATCH)
}

%file	*.ma
{
	MA_FILES = $(MA_FILES) $(MATCH)
}

%file	*.asm *.src
{
	ASM_FILES = $(ASM_FILES) $(MATCH)
}

%file	*.obj *.o *.out
{
	OBJ_FILES = $(OBJ_FILES) $(MATCH)
}

%file	*.lsl
{
	LSL_FLAGS = $(LSL_FLAGS) --lsl-file=$(MATCH)
}

# handle options
%option SWTARGET
{
	SWTARGET = $(MATCH)
	CCSW = ../../$(MATCH)/bin/c$(MATCH)
	C_FLAGS = $(C_FLAGS) --rtl-alloc --only-rtl-qualified --core-compatibility=$(MATCH)
	DEFAULT_LSL_FLAG =
	LLNG_FLAGS= $(LLNG_FLAGS) -D__BUS=option(SW_BUS) -D__SPACE=option(SW_SPACE) -D__SW_ARCH=option(SW_ARCH) -D__SW_LSL="\""option(SW_LSL)"\""
	C_FLAGS= $(C_FLAGS) --lsl-define=__BUS=option(SW_BUS) --lsl-define=__SPACE=option(SW_SPACE) --lsl-define=__SW_ARCH=option(SW_ARCH) --lsl-define=__SW_LSL="\""option(SW_LSL)"\""
}

%if	option(ISO_MODE) == "99"
{
	C_FLAGS = -c99 $(C_FLAGS)
}
%elif	option(ISO_MODE) == "90"
{
	C_FLAGS = -c90 $(C_FLAGS)
}

%option PRD_FILE
{
	C_FLAGS = $(C_FLAGS) --resource-definition=$(MATCH)
}

%option QUAL_FILE
{
	C_FLAGS = $(C_FLAGS) --qualifier-file=$(MATCH)
	SW_FLAGS = $(SW_FLAGS) --qualifier-file=$(MATCH)
}

%option SW_MIL
{
	SWMIL_FILES = $(SWMIL_FILES) $(MATCH)
}

%option LSLDEFINE
{
	C_FLAGS = $(C_FLAGS) --lsl-define=$(MATCH)
	LLNG_FLAGS = $(LLNG_FLAGS) --define=$(MATCH)
}

%option LSLINCDIR
{
	C_FLAGS = $(C_FLAGS) --lsl-include-directory=$(MATCH)
	LLNG_FLAGS = $(LLNG_FLAGS) --include-directory=$(MATCH)
}

%option CHC_LSL_INC
{
    LLNG_FLAGS = $(LLNG_FLAGS) -I option(CHC_LSL_INC) 
}

%option SW_LSL_INC
{
    LLNG_FLAGS = $(LLNG_FLAGS) -I option(SW_LSL_INC)
}


%option ENDIAN
{
	C_FLAGS = $(C_FLAGS) --endianness=$(MATCH)
	HW_TASK_FLAGS = $(HW_TASK_FLAGS) --endianness=$(MATCH)
	SW_TASK_FLAGS = $(SW_TASK_FLAGS) --endianness=$(MATCH)
	%switch	$(MATCH)
	{
	%case	big
	{
		SYSMILLIB_ENDIAN_SUFFIX =
	}
	%case	little
	{
		SYSMILLIB_ENDIAN_SUFFIX = le
	}
	}
}
%if	! option(ENDIAN)
{
    HW_TASK_FLAGS = $(HW_TASK_FLAGS) $(DEFAULT_ENDIAN_FLAG)
    SW_TASK_FLAGS = $(SW_TASK_FLAGS) $(DEFAULT_ENDIAN_FLAG)
}

%if	! option(NO_MAPFILE)
{
    HW_TASK_FLAGS = $(HW_TASK_FLAGS) -M
    SW_TASK_FLAGS = $(SW_TASK_FLAGS) -M
}

%option NOROMCOPY
{
	LLNG_FLAGS = $(LLNG_FLAGS) --no-rom-copy
}

%option USERINITCODE
{
	LLNG_FLAGS = $(LLNG_FLAGS) --user-provided-initialization-code
}

%option INT16BIT
{
	C_FLAGS = $(C_FLAGS) --integer-16bit
	SYSMILLIB_16BIT_SUFFIX = 16
}

%option ERROR_FILE
{
	C_FLAGS = $(C_FLAGS) --error-file
	LLNG_FLAGS = $(LLNG_FLAGS) --error-file
	SW_FLAGS = $(SW_FLAGS) --error-file
}

%option MACRO_DEFINE
{
	# Add macro definitions
	C_FLAGS = $(C_FLAGS) -D$(MATCH)
	ASM_DEFINE_FLAGS = $(ASM_DEFINE_FLAGS) -D$(MATCH)
	SW_FLAGS = $(SW_FLAGS) -D$(MATCH)
}

%option MACRO_UNDEF
{
	# Add macro un-definitions
	C_FLAGS = $(C_FLAGS) -U$(MATCH)
	SW_FLAGS = $(SW_FLAGS) -U$(MATCH)
}

%option INCLUDE_DIR
{
	# Add include directories
	C_FLAGS = $(C_FLAGS) -I$(MATCH)
	SW_FLAGS = $(SW_FLAGS) -I$(MATCH)
}

%option NO_DEFLIB_PATH
{
	LIB_FLAGS = -L
}

%option LIBRARY_DIR
{
	# Add library directories
	LIB_FLAGS = $(LIB_FLAGS) -L$(MATCH)
}

%option LIBRARY_FILE
{
	# Add libraries
	LIB_FLAGS = $(LIB_FLAGS) -l$(MATCH)
}

%option	ERRWARN
{
	C_FLAGS = $(C_FLAGS) --warnings-as-errors
	LLNG_FLAGS = $(LLNG_FLAGS) --warnings-as-errors
	SW_FLAGS = $(SW_FLAGS) --warnings-as-errors
}

%option NOWARN
{
	C_FLAGS = $(C_FLAGS) --no-warnings
	LLNG_FLAGS = $(LLNG_FLAGS) --no-warnings
	SW_FLAGS = $(SW_FLAGS) --no-warnings
}

%option PREPROC
{
	C_FLAGS = -E$(MATCH) $(C_FLAGS)
	CFE_OUT = pre
}

%option KEEP_FILES
{
	C_FLAGS = $(C_FLAGS) -k
	LLNG_FLAGS = $(LLNG_FLAGS) -k
	SW_FLAGS = $(SW_FLAGS) -k
}

%option TRADEOFF
{
	C_FLAGS = $(C_FLAGS) -t$(MATCH)
	SW_FLAGS = $(SW_FLAGS) -t$(MATCH)
}

%option VHDL
{
	%if	$(MATCH)
	{
		HDLHC_OUTPUT = --vhdl=$(MATCH)
	}
	%else
	{
		HDLHC_OUTPUT = --vhdl
	}
}
%option VERILOG
{
	%if	$(MATCH)
	{
		HDLHC_OUTPUT = --verilog=$(MATCH)
	}
	%else
	{
		HDLHC_OUTPUT = --verilog
	}
}

%option	PASS_C
{
	C_FLAGS = $(C_FLAGS) $(MATCH)
}

%option	PASS_ASM
{
	ASM_FLAGS = $(ASM_FLAGS) $(MATCH)
}

%option	PASS_SW
{
	SW_FLAGS = $(SW_FLAGS) $(MATCH)
}

%option	PASS_LLNG
{
	LLNG_FLAGS = $(LLNG_FLAGS) $(MATCH)
}

%option	PASS_HDLHC
{
	HDLHC_FLAGS = $(HDLHC_FLAGS) $(MATCH)
}

%option LSL_FILE
{
	LSL_FLAGS = $(LSL_FLAGS) --lsl-file=$(MATCH)
}

# non-control program options
#
# priority:	C  compiler and C++ compiler / Linker/Locator / Assembler

%set_option C_FLAGS
{
%include opt-chc.spec
}

%set_option ASM_FLAGS
{
%include opt-ashc.spec
}

%set_option LLNG_FLAGS
{
%include opt-llng.spec
}

%set_option HDLHC_FLAGS
{
%include opt-hdlhc.spec
}

# get all input files
ALL_FILES = $(C_FILES) $(MIL_FILES) $(SWMIL_FILES) $(MA_FILES) $(ASM_FILES)
%if	count(ALL_FILES) == 1
{
	SINGLE_INPUT = 1
}

# actions
FIRST_INPUT =
%action $(ALL_FILES)
{
	%if	!$(FIRST_INPUT)
	{
		FIRST_INPUT = $(MATCH)
	}
}

%single_action $(C_FILES)
{
	%if	option(SWTARGET )
	{
	    # generate a header file to define chc-specific qualifiers like __mem0 away for the sw compiler
	    %if  option(CORE_INCLUDE)
	    {
		QUAL_BASE = option(CORE_INCLUDE)
	    }
	    %else
	    {
		QUAL_BASE = "chc_redefine"
	    }
	    OUT = output_file($(QUAL_BASE), "h", $(SINGLE_INPUT), option(CORE_INCLUDE), "1" )
	    REDEFINE_QUAL_FILE = $(OUT)
	    $(CFE) --redefine-qualifiers=$(REDEFINE_QUAL_FILE)
	    C_FLAGS = $(C_FLAGS) -H$(REDEFINE_QUAL_FILE)
	    SW_FLAGS = $(SW_FLAGS) -H$(REDEFINE_QUAL_FILE)
	}
}

# Compiler invocation
%single_action $(C_FILES) $(MIL_FILES) $(MA_FILES)
{
	%if	option(SWTARGET )
	{
		OUTQUAL = output_file($(FIRST_INPUT), $(SW_QUAL), "1", "1", "1" )
		C_FLAGS = $(C_FLAGS) --sw-qual=$(OUTQUAL)
		SW_FLAGS = $(SW_FLAGS) --qualifier-file=$(OUTQUAL)
	}

	%if	! option(ENDIAN)
	{
		C_FLAGS = $(C_FLAGS) $(DEFAULT_ENDIAN_FLAG)
	}
	%if	! $(LSL_FLAGS)
	{
		C_FLAGS = $(C_FLAGS) $(DEFAULT_LSL_FLAG)
	}
	%else
	{
		C_FLAGS = $(C_FLAGS) $(LSL_FLAGS)
	}
	%if	option(NO_SYSLIBS)
	{
		# No default MIL libraries
	}
	%else
	{
		MILLIBS = $(MILLIBS) $(LIBDIR)/$(SYSMILLIB_NAME)$(SYSMILLIB_ENDIAN_SUFFIX)$(SYSMILLIB_16BIT_SUFFIX).ma
	}

	%if	option(MILLINK)
	{
		OUT = output_file($(MATCH), $(MIL_OUT), $(SINGLE_INPUT), option(C_MIL))
		$(CFE) $(C_FLAGS) --mil -o $(OUT) $(MATCH) $(MILLIBS)
	}
	%elif	option(PREPROC)
	{
		OUT = output_file($(FIRST_INPUT), $(CFE_OUT), $(SINGLE_INPUT), "1" )
		$(CFE) $(C_FLAGS) $(MATCH)
	}	
	%else
	{
		%if	option(C_ASSEMBLY)
		{
			OUT = output_file($(OUTPUT), "src", "1", "1" )
		}
		%else
		{
			OUT = output_file($(FIRST_INPUT), $(CFE_OUT), $(SINGLE_INPUT), option(C_ASSEMBLY))
		}
		$(CFE) $(C_FLAGS) -o$(OUT) $(MATCH) $(MILLIBS)

		%if	!option(CHECK)
		{
			GEN_ASM_FILES = $(GEN_ASM_FILES) $(OUT)
		}
	}
}

%stop option(C_MIL) || option(PREPROC)

%stop option(C_ASSEMBLY) || option(PREPROC)

# Assembler invocation for user assembly files
%action $(ASM_FILES)
{
	#OUT = output_file($(MATCH), $(ASM_OUT), $(SINGLE_INPUT), option(C_OBJECT))
	OUT = output_file($(OUTPUT), $(ASM_OUT), "1", "1" )
	%if	$(ASM_LIST_FILE)
	{
		LST_NAME = ""
		%if	$(SINGLE_INPUT)
		{
			LST_NAME = $(ASM_LIST_NAME)
		}
		%if	! $(LST_NAME)
		{
			LST_NAME = output_file($(MATCH), $(ASM_LST), "1", option(C_OBJECT), "1")
		}
		ASM_LST_FLAGS = -l$(LST_NAME)
	}
	%else
	{
		ASM_LST_FLAGS = ""
	}

	$(ASM) $(ASM_DEFINE_FLAGS) $(ASM_FLAGS) $(ASM_LST_FLAGS) -o $(OUT) $(MATCH)

	%if	!option(CHECK)
	{
		GEN_OBJ_FILES = $(GEN_OBJ_FILES) $(OUT)
	}
}

# Assembler invocation for generated assembly files
%action $(GEN_ASM_FILES)
{
	OUT = output_file($(OUTPUT), $(ASM_OUT), "", "1", "1" )
	%if	$(ASM_LIST_FILE)
	{
		LST_NAME = ""
		%if	$(SINGLE_INPUT)
		{
			LST_NAME = $(ASM_LIST_NAME)
		}
		%if	! $(LST_NAME)
		{
			LST_NAME = output_file($(MATCH), $(ASM_LST), "", option(C_OBJECT), "1")
		}
		ASM_LST_FLAGS = -l$(LST_NAME)
	}
	%else
	{
		ASM_LST_FLAGS = ""
	}

	$(ASM) $(ASM_FLAGS) $(ASM_LST_FLAGS) -o $(OUT) $(MATCH)

	%if	!option(CHECK)
	{
		GEN_OBJ_FILES = $(GEN_OBJ_FILES) $(OUT)

		%if option(SWTARGET)
		{
		    SW_OBJ_FILES = $(SW_OBJ_FILES) user_func( sw_obj_file, $(OUT), $(ASM_OUT))
	        }
	}
}

%stop option(C_OBJECT)

# software invocation
%single_action $(C_FILES) $(SWMIL_FILES)
{
	%if	$(SWTARGET)
	{
	    %if option(SW_OUTPUT)
	    {
		SW_BASE = option(SW_OUTPUT)
		SW_OBJ	= obj
		SW_ELF	= elf
	    }
	    %else
	    {
		SW_BASE = $(FIRST_INPUT)
	    }
	    SW_OBJ_FILE = output_file($(SW_BASE), $(SW_OBJ), "", "1" )

	    # FIXME: -t not possible, we'd clobber the chc .src and .obj intermediates.
	    $(CCSW) -cl -o $(SW_OBJ_FILE) -v $(SW_FLAGS) $(MATCH) $(SW_LIBS)

	    SW_OBJ_FILES = $(SW_OBJ_FILES) $(SW_OBJ_FILE)
	    ELF_FILE = output_file($(SW_BASE), $(SW_ELF), "", "1", "1" )
	    HEX_FILE = output_file($(SW_BASE), "", "", "1", "1" )
	    SW_TASK_FLAGS = -c$(HEX_FILE):IHEX -k $(SW_TASK_FLAGS) 
	    SW_TASK = -Csw -o $(ELF_FILE) $(SW_TASK_FLAGS) $(SW_OBJ_FILES) $(SW_LIBS) --new-task -Chc
	}
}


%single_action $(OBJ_FILES) $(GEN_OBJ_FILES) $(LIB_FILES)
{
	OBJ_FILES = $(OBJ_FILES) $(GEN_OBJ_FILES) $(LIB_FILES)
}

# Linker invocation
%single_action $(OBJ_FILES) $(SW_ELF)
{
	# Use variable OUTPUT to set the output name
	%if	! option(NOROMCOPY)
	{
		HW_TASK_FLAGS = $(HW_TASK_FLAGS) --no-rom-copy
	}
	%if	! option(USERINITCODE)
	{
		HW_TASK_FLAGS = $(HW_TASK_FLAGS) --user-provided-initialization-code
	}
	%if	! $(LSL_FLAGS)
	{
		LLNG_FLAGS = $(LLNG_FLAGS) $(DEFAULT_LSL_FLAG)
	}
	%else
	{
		LLNG_FLAGS = $(LLNG_FLAGS) $(LSL_FLAGS)
	}
	OUT_FILE = output_file($(OUTPUT), $(LLNG_OUT), "1", "1" )
	HW_TASK = $(HW_TASK_FLAGS) -o $(OUT_FILE) $(OBJ_FILES) $(LIB_FLAGS) $(SYSLIBS_DIR) $(SYSLIBS)

	$(LLNG) $(LLNG_FLAGS) $(SW_TASK) $(HW_TASK) 

	%if	!option(CHECK)
	{
		GEN_ELF_FILES = $(GEN_ELF_FILES) $(OUT_FILE)
	}
}

%stop option(C_ELF)

# Hardware compiler
%single_action $(ELF_FILES) $(GEN_ELF_FILES)
{
	%if	! $(HDLHC_OUTPUT)
	{
		OUT_FILE = output_file($(OUTPUT), "vhdl", "1", "1" )
		HDLHC_OUTPUT = --vhdl=$(OUT_FILE)
	}
	$(HDLHC) $(HDLHC_FLAGS) $(MATCH) $(HDLHC_OUTPUT)
}
