-- -----------------------------------------------------------------------------
Library IEEE;
Use IEEE.Std_Logic_1164.All;
-- -----------------------------------------------------------------------------

-- -----------------------------------------------------------------------------
Entity Configurable_ReplaceWith_Designator Is
Port (
    STB_I : In  Std_Logic;
    CYC_I : In  Std_Logic;
    ACK_O : Out Std_Logic;
    ADR_I : In  Std_Logic_Vector(3 Downto 0);
    DAT_O : Out Std_Logic_Vector(7 Downto 0);
    DAT_I : In  Std_Logic_Vector(7 Downto 0);
    WE_I  : In  Std_Logic;
    CLK_I : In  Std_Logic;
    RST_I : In  Std_Logic;
    INT_O : Out Std_Logic;

    --ReplaceWith_ExternalInterface
    ONE_WIRE_BUS_H : InOut Std_Logic; --IncludeIf_Bus8_Enabled                  --ExcludeIf_SingleBus
    ONE_WIRE_BUS_G : InOut Std_Logic; --IncludeIf_Bus7_Enabled                  --ExcludeIf_SingleBus
    ONE_WIRE_BUS_F : InOut Std_Logic; --IncludeIf_Bus6_Enabled                  --ExcludeIf_SingleBus
    ONE_WIRE_BUS_E : InOut Std_Logic; --IncludeIf_Bus5_Enabled                  --ExcludeIf_SingleBus
    ONE_WIRE_BUS_D : InOut Std_Logic; --IncludeIf_Bus4_Enabled                  --ExcludeIf_SingleBus
    ONE_WIRE_BUS_C : InOut Std_Logic; --IncludeIf_Bus3_Enabled                  --ExcludeIf_SingleBus
    ONE_WIRE_BUS_B : InOut Std_Logic; --IncludeIf_Bus2_Enabled                  --ExcludeIf_SingleBus
    ONE_WIRE_BUS_A : InOut Std_Logic                                            --ExcludeIf_SingleBus

    ONE_WIRE_BUS   : InOut Std_Logic  --IncludeIf_SingleBus
);
End;
-- -----------------------------------------------------------------------------


-- -----------------------------------------------------------------------------
Architecture RTL Of Configurable_ReplaceWith_Designator Is
-- -----------------------------------------------------------------------------

    -- -------------------------------------------------------------------------
    Component WB_OWM Is
        Port (
            STB_I  : In  Std_Logic;
            CYC_I  : In  Std_Logic;
            ACK_O  : Out Std_Logic;
            ADR_I  : In  Std_Logic_Vector(2 Downto 0);
            DAT_O  : Out Std_Logic_Vector(7 Downto 0);
            DAT_I  : In  Std_Logic_Vector(7 Downto 0);
            WE_I   : In  Std_Logic;
            CLK_I  : In  Std_Logic;
            RST_I  : In  Std_Logic;
            INT_O  : Out Std_Logic;
            DQ_EN  : Out Std_Logic;
            DQ_IN  : In  Std_Logic;
            DQ_OUT : Out Std_Logic
        );
    End Component;
    -- -------------------------------------------------------------------------

    Signal WishboneRequest      : Std_Logic;
    Signal WishboneWrite        : Std_Logic;
    Signal WishboneRead         : Std_Logic;
    Signal Wishbone2Controller  : Std_Logic;
    Signal Wishbone2Interface   : Std_Logic;
    Signal ControllerAck        : Std_Logic;
    Signal ControllerWbDataOut    : Std_Logic_Vector(7 Downto 0);
    Signal ControllerDataEnable : Std_Logic;
    Signal ControllerDataIn     : Std_Logic;
    Signal ControllerDataOut     : Std_Logic;

    Signal InterfaceAck         : Std_Logic;
    Signal InterfaceDataOut     : Std_Logic_Vector(7 Downto 0);
    Signal InterfaceSelect      : Std_Logic_Vector(7 Downto 0);

-- -----------------------------------------------------------------------------
Begin
-- -----------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    WishboneRequest     <= STB_I And CYC_I;
    WishboneWrite       <= WishboneRequest  And     WE_I;
    WishboneRead        <= WishboneRequest  And Not WE_I;
    Wishbone2Controller <= WishboneRequest  And Not ADR_I(3);
    Wishbone2Interface  <= WishboneRequest  And     ADR_I(3);
    InterfaceAck        <= Wishbone2Interface;
    ACK_O               <= ControllerAck    Or InterfaceACk;
    DAT_O               <= ControllerWbDataOut When Wishbone2Controller='1' Else InterfaceSelect;
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------
    Configurable_ReplaceWith_Designator_Inst : WB_OWM Port Map
    (
        STB_I  => Wishbone2Controller,
        CYC_I  => Wishbone2Controller,
        ACK_O  => ControllerAck,
        ADR_I  => ADR_I(2 Downto 0),
        DAT_O  => ControllerWbDataOut,
        DAT_I  => DAT_I,
        WE_I   => WE_I,
        CLK_I  => CLK_I,
        RST_I  => RST_I,
        INT_O  => INT_O,
        DQ_EN  => ControllerDataEnable,
        DQ_IN  => ControllerDataIn,
        DQ_OUT => ControllerDataOut
    );
    -- ------------------------------------------------------------------------




    -- ------------------------------------------------------------------------
    Process(CLK_I)
    Begin
        If Rising_Edge(CLK_I) Then
            If RST_I='1' Then
                InterfaceSelect <= x"01";
            Else
                If Wishbone2Interface='1' And WishboneWrite='1' Then
                    InterfaceSelect <= DAT_I;
                End If;
            End If;
        End If;
    End Process;
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------                                                                     --ExcludeIf_SingleBus
    Process(ControllerDataEnable,                                                                                                                   --ExcludeIf_SingleBus
            InterfaceSelect,                                                                                                                        --ExcludeIf_SingleBus
            ControllerDataOut                                                                                                                       --ExcludeIf_SingleBus
            )                                                                                                                                       --ExcludeIf_SingleBus
    Begin                                                                                                                                           --ExcludeIf_SingleBus
        ONE_WIRE_BUS_A <= 'Z';                                                                                                                      --ExcludeIf_SingleBus
        ONE_WIRE_BUS_B <= 'Z';                                                  --IncludeIf_Bus2_Enabled                                            --ExcludeIf_SingleBus
        ONE_WIRE_BUS_C <= 'Z';                                                  --IncludeIf_Bus3_Enabled                                            --ExcludeIf_SingleBus
        ONE_WIRE_BUS_D <= 'Z';                                                  --IncludeIf_Bus4_Enabled                                            --ExcludeIf_SingleBus
        ONE_WIRE_BUS_E <= 'Z';                                                  --IncludeIf_Bus5_Enabled                                            --ExcludeIf_SingleBus
        ONE_WIRE_BUS_F <= 'Z';                                                  --IncludeIf_Bus6_Enabled                                            --ExcludeIf_SingleBus
        ONE_WIRE_BUS_G <= 'Z';                                                  --IncludeIf_Bus7_Enabled                                            --ExcludeIf_SingleBus
        ONE_WIRE_BUS_H <= 'Z';                                                  --IncludeIf_Bus8_Enabled                                            --ExcludeIf_SingleBus
                                                                                                                                                    --ExcludeIf_SingleBus
           If InterfaceSelect(0) = '1' And ControllerDataEnable = '0' Then ONE_WIRE_BUS_A  <= ControllerDataOut;                                    --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(1) = '1' And ControllerDataEnable = '0' Then ONE_WIRE_BUS_B  <= ControllerDataOut;       --IncludeIf_Bus2_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(2) = '1' And ControllerDataEnable = '0' Then ONE_WIRE_BUS_C  <= ControllerDataOut;       --IncludeIf_Bus3_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(3) = '1' And ControllerDataEnable = '0' Then ONE_WIRE_BUS_D  <= ControllerDataOut;       --IncludeIf_Bus4_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(4) = '1' And ControllerDataEnable = '0' Then ONE_WIRE_BUS_E  <= ControllerDataOut;       --IncludeIf_Bus5_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(5) = '1' And ControllerDataEnable = '0' Then ONE_WIRE_BUS_F  <= ControllerDataOut;       --IncludeIf_Bus6_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(6) = '1' And ControllerDataEnable = '0' Then ONE_WIRE_BUS_G  <= ControllerDataOut;       --IncludeIf_Bus7_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(7) = '1' And ControllerDataEnable = '0' Then ONE_WIRE_BUS_H  <= ControllerDataOut;       --IncludeIf_Bus8_Enabled     --ExcludeIf_SingleBus
        Else                                                                                                                                        --ExcludeIf_SingleBus
                                                                           ONE_WIRE_BUS_A <= 'Z';                                                   --ExcludeIf_SingleBus
                                                                           ONE_WIRE_BUS_B <= 'Z';                      --IncludeIf_Bus2_Enabled     --ExcludeIf_SingleBus
                                                                           ONE_WIRE_BUS_C <= 'Z';                      --IncludeIf_Bus3_Enabled     --ExcludeIf_SingleBus
                                                                           ONE_WIRE_BUS_D <= 'Z';                      --IncludeIf_Bus4_Enabled     --ExcludeIf_SingleBus
                                                                           ONE_WIRE_BUS_E <= 'Z';                      --IncludeIf_Bus5_Enabled     --ExcludeIf_SingleBus
                                                                           ONE_WIRE_BUS_F <= 'Z';                      --IncludeIf_Bus6_Enabled     --ExcludeIf_SingleBus
                                                                           ONE_WIRE_BUS_G <= 'Z';                      --IncludeIf_Bus7_Enabled     --ExcludeIf_SingleBus
                                                                           ONE_WIRE_BUS_H <= 'Z';                      --IncludeIf_Bus8_Enabled     --ExcludeIf_SingleBus
        End If;                                                                                                                                     --ExcludeIf_SingleBus
    End Process;                                                                                                                                    --ExcludeIf_SingleBus
    ONE_WIRE_BUS <= ControllerDataOut When ControllerDataEnable = '0' Else 'Z';                                        --IncludeIf_SingleBus
    -- ------------------------------------------------------------------------

    -- ------------------------------------------------------------------------                              --ExcludeIf_SingleBus
    Process(InterfaceSelect,                                                                                 --ExcludeIf_SingleBus
            ONE_WIRE_BUS_B,                                                     --IncludeIf_Bus2_Enabled     --ExcludeIf_SingleBus
            ONE_WIRE_BUS_C,                                                     --IncludeIf_Bus3_Enabled     --ExcludeIf_SingleBus
            ONE_WIRE_BUS_D,                                                     --IncludeIf_Bus4_Enabled     --ExcludeIf_SingleBus
            ONE_WIRE_BUS_E,                                                     --IncludeIf_Bus5_Enabled     --ExcludeIf_SingleBus
            ONE_WIRE_BUS_F,                                                     --IncludeIf_Bus6_Enabled     --ExcludeIf_SingleBus
            ONE_WIRE_BUS_G,                                                     --IncludeIf_Bus7_Enabled     --ExcludeIf_SingleBus
            ONE_WIRE_BUS_H,                                                     --IncludeIf_Bus8_Enabled     --ExcludeIf_SingleBus
            ONE_WIRE_BUS_A                                                                                  --ExcludeIf_SingleBus
            )                                                                                                --ExcludeIf_SingleBus
    Begin                                                                                                    --ExcludeIf_SingleBus
           If InterfaceSelect(0) = '1' Then ControllerDataIn <= ONE_WIRE_BUS_A;                              --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(1) = '1' Then ControllerDataIn <= ONE_WIRE_BUS_B; --IncludeIf_Bus2_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(2) = '1' Then ControllerDataIn <= ONE_WIRE_BUS_C; --IncludeIf_Bus3_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(3) = '1' Then ControllerDataIn <= ONE_WIRE_BUS_D; --IncludeIf_Bus4_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(4) = '1' Then ControllerDataIn <= ONE_WIRE_BUS_E; --IncludeIf_Bus5_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(5) = '1' Then ControllerDataIn <= ONE_WIRE_BUS_F; --IncludeIf_Bus6_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(6) = '1' Then ControllerDataIn <= ONE_WIRE_BUS_G; --IncludeIf_Bus7_Enabled     --ExcludeIf_SingleBus
        ElsIf InterfaceSelect(7) = '1' Then ControllerDataIn <= ONE_WIRE_BUS_H; --IncludeIf_Bus8_Enabled     --ExcludeIf_SingleBus
        Else                                ControllerDataIn <= '1';                                         --ExcludeIf_SingleBus
        End If;                                                                                              --ExcludeIf_SingleBus
    End Process;                                                                                             --ExcludeIf_SingleBus
    -- ------------------------------------------------------------------------                              --ExcludeIf_SingleBus
    ControllerDataIn <= ONE_WIRE_BUS;                                            --IncludeIf_SingleBus
    -- ------------------------------------------------------------------------
-- -----------------------------------------------------------------------------
End RTL;
-- -----------------------------------------------------------------------------

