/**********************************************************************
**  VERSION CONTROL:    @(#)t_timer.c   1.50 04/09/22                    
**  DESCRIPTION:                                                      *
**  Source code for rtos timer interrupt.                             *
**********************************************************************/
#include "g_conf.h"

#if ((_os_NO_ALARM>0) && (_os_OS_0_USERTOSTIMER == 1))

#include "c_common.h"
#include "c_target.h"

/************************************************************************
 *  FUNCTION:             _os_isr_timer
 *  DESCRIPTION:                                                        *       
 *      Interrupt handler for the rtos timer interrupt.                 *
 ************************************************************************/
__interrupt(__INTMYNO(_os_OS_0_RTOSTIMERLEVEL)) 
_os_ISR2_FRAME  void _os_clock( void )
{
        _os_BodySystemClock();
}

void _os_StartTimer(void)
{
        InitRTOSTimer();
}

#endif








