/******************************************************************************
 * FILE:        @(#)t_rtos.h    1.71 04/10/29
 * DESCRIPTION:
 *      Specific 8051 definitions for this osek implementation
 ******************************************************************************/
#ifndef _T_RTOS_H
#define _T_RTOS_H

#include "g_conf_types.h"

#define _os_RTOSMEM     
#define _os_STACKMEM

extern char _lc_ub_data_extend[];
extern char _lc_ue_data_extend[];

/******************************************************************************
 * lay out of the task context
 ******************************************************************************/
typedef struct _os_ctx  _os_CTX;
struct _os_ctx
{
#define _os_CTX_PCL    0
        uint8_t pcl;
#define _os_CTX_PCH    1
        uint8_t pch;
#define _os_CTX_ACC    2
        uint8_t acc;
#define _os_CTX_B      3
        uint8_t b;
#define _os_CTX_DPL    4
        uint8_t dpl;
#define _os_CTX_DPH    5
        uint8_t dph;
#define _os_CTX_R0    6
        uint8_t ro;
#define _os_CTX_R1    7
        uint8_t r1;
#define _os_CTX_R2    8
        uint8_t r2;
#define _os_CTX_R3    9
        uint8_t r3;
#define _os_CTX_R4    10
        uint8_t r4;
#define _os_CTX_R5    11
        uint8_t r5;
#define _os_CTX_R6    12
        uint8_t r6;
#define _os_CTX_R7    13
        uint8_t r7;
#define _os_CTX_PSW    14
        uint8_t psw;
#define _os_CTX_VSPL    15
        uint8_t vsph;
#define _os_CTX_VSPH    16
        uint8_t vspl;

#if (_os_OS_0_CORE != _os_OS_TSK51A)
#define _os_CTX_DPL1    17
        uint8_t dpl1;
#define _os_CTX_DPH1    18
        uint8_t dph1;
#define _os_CTX_DPS     19
        uint8_t dps;
#endif

};

#if (_os_OS_0_CORE == _os_OS_TSK51A)
#define   _os_NOBYTESCONTEXTPOPPUSH  15
#else
#define   _os_NOBYTESCONTEXTPOPPUSH  18
#endif

#if (_os_OS_0_CORE != _os_OS_TSK51A)
#       define _os_CORE_EXTRACTX        0,0,0,
#else
#       define _os_CORE_EXTRACTX        
#endif


/******************************************************************************
 * Macros to fill task's stacks (from g_conf.c)
 ******************************************************************************/
#if ( _os_OS_0_EXTDATASIZE >0 )
#define EDA_STACK_BUFFER        uint8_t eda[_os_OS_0_EXTDATASIZE];
#else
#define EDA_STACK_BUFFER                        
#endif


#define _os_TYPEDEF_STACKBUFFER(var)    typedef struct _os_buffer_ ## var  _os_STACKBUFFER_ ## var ;\
                                        struct _os_buffer_## var {\
                                                uint8_t vstack[_os_TASK_ ## var ## _VSTACK];\
                                                _os_CTX         ctx;\
                                                uint8_t sstack[_os_TASK_ ## var ## _SSTACK];\
                                                EDA_STACK_BUFFER \
                                        };

#define _os_VIRTUALSTACKFILL    { 1, },

#define _os_CTXSTACKFILL(var1,var2)     {\
                0,\
                0,\
                0x5a,\
                0x5a,\
                0x5a,\
                0x5a,\
                0x0,\
                0x1,\
                0x2,\
                0x3,\
                0x4,\
                0x5,\
                0x6,\
                0x7,\
                0,\
                0,\
                0, \
                _os_CORE_EXTRACTX       \
                },

#define _os_SYSTEMSTACKFILL     { 2, },

#if (_os_OS_0_EXTDATASIZE>0)
#define _os_EDASTACKFILL        { 3, }
#else
#define _os_EDASTACKFILL                
#endif

#define _os_STACKFILL(par1,par2) _os_VIRTUALSTACKFILL \
                                 _os_CTXSTACKFILL(par1,par2) \
                                 _os_SYSTEMSTACKFILL \
                                 _os_EDASTACKFILL

#define _os_SSTACKIDLEMINSIZE       40
#define _os_VSTACKIDLEMINSIZE       10

#if ( (_os_OS_0_POSTMORTEM == _os_OS_REALTIME) && (_os_OS_0_HARDLOGGING==0) )
#       define _os_VSTACKSOFTLOGSIZE    30
#       define _os_VSTACKIDLESIZE      (_os_VSTACKIDLEMINSIZE +  _os_VSTACKSOFTLOGSIZE)
#       define _os_SSTACKSOFTLOGSIZE    12
#       define _os_SSTACKIDLESIZE      (_os_SSTACKIDLEMINSIZE +  _os_SSTACKSOFTLOGSIZE)
#else
#       define _os_VSTACKIDLESIZE      _os_VSTACKIDLEMINSIZE 
#       define _os_SSTACKIDLESIZE      _os_SSTACKIDLEMINSIZE 
#endif
                
typedef struct _os_stackidle _os_IDLESTACK;
struct _os_stackidle
{
        uint8_t  vstack[_os_VSTACKIDLESIZE];
        _os_CTX        ctx;
        uint8_t  sstack[_os_SSTACKIDLESIZE];
#if (_os_OS_0_EXTDATASIZE>0)
        uint8_t  eda[_os_OS_0_EXTDATASIZE];
#endif
};
extern _os_IDLESTACK   _os_idle_stack;

/******************************************************************************
 * Macros to build ISRs frames
 ******************************************************************************/

#if (_os_OS_0_CORE != _os_OS_TSK51A)
#       define _os_CORE_EXTRAPUSHISR    __asm("push DPL1");\
                                        __asm("push DPH1");\
                                        __asm("push DPS");
#else
#       define _os_CORE_EXTRAPUSHISR    
#endif


#if (_os_OS_0_CORE != _os_OS_TSK51A)
#       define _os_CORE_EXTRAPOPISR     __asm("pop  DPS");\
                                        __asm("pop  DPH1");\
                                        __asm("pop  DPL1");
#else
#       define _os_CORE_EXTRAPOPISR     
#endif

#define INTERRUPT(var)          __interrupt(__INTMYNO(var))

#define _os_ISR2_FRAME          __frame(A, B, DPL, DPH, R0, R1, R2, R3, R4, R5, R6, R7,PSW)

#define _os_ISR2_PUSH           __asm("push __SP");\
                                __asm("push __SP+1");\
                                _os_CORE_EXTRAPUSHISR 

#define _os_ISR2_POP            _os_CORE_EXTRAPOPISR \
                                __asm("pop __SP+1");\
                                __asm("pop __SP");

#define _os_ISR1_FRAME          _os_ISR2_FRAME
#define _os_ISR1_PUSH           _os_ISR2_PUSH
#define _os_ISR1_POP            _os_ISR2_POP    

/******************************************************************************
 * SuspendOSInterrupts/ResumeOSInterrupts make use
 * (if necessary) of these macros to suspend/resume
 * individually ISR2 interrupts (Arch. type A).
 *      YES in 8051                                             
 ******************************************************************************/
#define _os_SuspendISR(var)     _os_isr_ ## var ## _status = _os_ISR_ ## var ## _ENBIT; \
                                _os_ISR_ ## var ## _ENBIT  = 0;
                
#define _os_ResumeISR(var)      _os_ISR_ ## var ## _ENBIT  = _os_isr_ ## var ## _status; 

#if (_os_OS_0_EXTDATASIZE>0)
#define _os_SAVEINTEXTENDDATA()                 _os_SaveIntExtendData();
#else
#define _os_SAVEINTEXTENDDATA()
#endif

#if ( _os_NO_ISR>0 )
#define _os_SAVEVSPTOISP()      if ((_os_isr2_counter+_os_isr1_counter)==0) \
                                _os_SetVSPtoIS();
#elif (_os_OS_0_USERTOSTIMER>0) 
#define _os_SAVEVSPTOISP()      _os_SetVSPtoIS();
#else
#define _os_SAVEVSPTOISP()      
#endif

/******************************************************************************
 See 'c_target.h' for description of these macros
 ******************************************************************************/
#define _os_ENTERISR1()         _os_DisableInterrupts();        \
                                _os_ISR1_PUSH                   \
                                _os_SAVEVSPTOISP()

#define _os_ENTERISR2()         _os_DisableInterrupts();        \
                                _os_ISR2_PUSH                   \
                                _os_SAVEVSPTOISP()

#define _os_EXITISR1()          _os_ISR1_POP                    \
                                _os_EnableInterrupts();

#define _os_EXITISR2()          _os_ISR2_POP                    \
                                _os_EnableInterrupts();
                        
#define _os_SAVEINTCONTEXT()    _os_SAVEINTEXTENDDATA() 

#define _os_RELOADRTOSTIMER()    ReloadRTOSTimer();     

/******************************************************************************
 * MACROs:              _os_x0_TARGETRTOS_INIT
 * DESCRIPTION:
 *      Define the initialization values of the OIL
 *      8051 specific attributes for RES_SCHEDULER
 *      (x=RESOURCE), SYSTEM_COUNTER (x=COUNTER) and
 *      IDLE (x=TASK) (see target.oil).
 ******************************************************************************/
/* VSTACK and SSTACK for IDLE  */
#define _os_TASK0_TARGETRTOS_INIT       _os_VSTACKIDLESIZE,\
                                        _os_SSTACKIDLESIZE,

/* No attributes for RESOURCE and COUNTER in target.oil */
#define _os_RESOURCE0_TARGETRTOS_INIT
#define _os_COUNTER0_TARGETRTOS_INIT

/******************************************************************************
 * MACROs:      _os_x_TARGETRTOS, _os_x_TARGETRTOSINIT
 * DESCRIPTION:
 *      Define the non-oil 8051 part of OIL object _os_x.
 * REMARKS:
 *      ONLY if non-empty.
 *****************************************************************************/

/******************************************************************************
 * MACROs:      _os_TASK_TARGETRTOS, _os_TASK_TARGETRTOSINIT
 * DESCRIPTION:
 *      8051 non-oil part for a _os_TASK OIL object
 *      - bstack: beginning of the system stack back area for the task.
 *                Value must remain unaltered.
 *      - sp:     system stack size of a saved task.
 *      - beda:   begin of extended data backup area for the task.
 *                Value must remain unaltered.
 *****************************************************************************/
#if (_os_OS_0_EXTDATASIZE>0)
#define  _os_TASK_BEDA                  uint16_t                 beda;
#define  _os_TASK_BEDAINIT              0,
#else
#define  _os_TASK_BEDA                  
#define  _os_TASK_BEDAINIT              
#endif

#define _os_TASK_TARGETRTOS             uint16_t                 bstack;\
                                        _os_TASK_BEDA\
                                        uint_fast8_t             sp;

                                        
#define _os_TASK_TARGETRTOSINIT         0,\
                                        _os_TASK_BEDAINIT\
                                        sizeof(_os_CTX),

                                        
#endif

