/******************************************************************************
 *  FILE:       @(#)t_idle.c    1.47 04/10/29   
 *  DESCRIPTION:
 *      Target specific parts of the idle task.
 *****************************************************************************/
#include "g_conf.h" 
#include "c_common.h"
#include "t_rtos.h"

/******************************************************************************
 * idle task stack
 *****************************************************************************/
_os_IDLESTACK  _os_idle_stack = {
        { 0x5A,0xA5, },     /* vstack */
    { 
        0, /* runtime */
        0, /* runtime */        
        0x5a,
        0x5a,
        0x5a,
        0x5a,
        0,
        1,
        2,
        3,
        4,
        5,
        6,
        7,
        0,
        0, /* runtime */
        0, /* runtime */
        _os_CORE_EXTRACTX 
    },
#if ( (_os_OS_0_POSTMORTEM == _os_OS_REALTIME) && (_os_OS_0_HARDLOGGING==0) )
    { 2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0xa5,0x5a }, /* sstack */
#else
    { 2,0,0,0,0,0,0xa5,0x5a }, /* sstack */
#endif
#if (_os_OS_0_EXTDATASIZE)
    { 3, }      /* eda    */
#endif
};

/******************************************************************************
 * Buffer for locals and parameters in the interrupt
 * virtual stack.
 * (non initialized -> smaller image)
 *****************************************************************************/
char __xdata _os_VISRSTACK[ _os_OS_0_VISRSTACK < 2 ? 2 : _os_OS_0_VISRSTACK ];

void _os_InitIdle(void)
{
    /* I cannot at compile time: C front */
    _os_idle_stack.ctx.pch  = (uint8_t) ((uint16_t)&_os_Idle  >> 8);
    _os_idle_stack.ctx.pcl  = (uint8_t) ((uint16_t)&_os_Idle);
    _os_idle_stack.ctx.vsph = (uint8_t) ((uint16_t) &_os_idle_stack.vstack[_os_VSTACKIDLESIZE-1] >> 8);
    _os_idle_stack.ctx.vsph = (uint8_t) ((uint16_t) &_os_idle_stack.vstack[_os_VSTACKIDLESIZE-1]);
     
    _os_SetTaskReady(&_os_task_table[_os_idle]);

    _os_task_table[0].bstack = (uint16_t)&_os_idle_stack.ctx.pcl;
    
#if (_os_OS_0_EXTDATASIZE)
     _os_task_table[0].beda   = (uint16_t)&_os_idle_stack.eda[0];
#endif       
        return;
}

/******************************************************************************
 * FUNCTION:            _os_EnterWait
 * DESCRIPTION:
 *      Target specific actions to enter a mode of less power consumption
 *      while still handling interrupts.
 ****************************************************************************/
void _os_EnterWait(void) {}


