/************************************************************************
**  FILE:      @(#)c_waitevent.c        1.27 04/09/15
**  DESCRIPTION:                                                        *
**      Source code for 'WaitEvent'                                     *
************************************************************************/
#include "c_common.h"
#include "c_target.h"

#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#include "c_postmortem.h"
#endif

StatusType
#if (_os_SIA>0)
_os_WaitEvent
#else
WaitEvent
#endif
(EventMaskType mask)
{

        StatusType              ret   = E_OK;
        uint_fast8_t            wait  = 1;

#if (_os_NO_EVENT>0)
        _os_EVENTMASKTYPE        lmask =  (_os_EVENTMASKTYPE)mask;         
        
        _os_lock++;
        
        /* system entry actions */
        _os_ServiceEntry(_os_N_WaitEvent);
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        /* Log an error if task currently owns a non-internal resource. */
         if (_os_current_task->res != _os_INVALID_RES
            && _os_resource_table[_os_current_task->res].RESOURCEPROPERTY != _os_RE_INTERNAL)
         {
                 /* no concurrency issues, only '_os_current_task' can update
                  * _os_current_task->res */
                ret = E_OS_RESOURCE;
         } 
        else 
        if ( !(_os_current_task->events & lmask) )
        {
                /* this mask does not contain any of the task's possible events */
                ret = E_OS_SYS_VALUE;
        }
        else if ( _os_IsInterruptLevel() )
        {
                /* Call at interrupt level */
                ret = E_OS_CALLEVEL;
        }
        
        if(ret!=E_OK)
        {
                #if (_os_OS_0_ERRORHOOK==1)
                _os_LogError(ret,_os_TO_WAIT_EVENT,(int32_t)lmask,-1,-1);
                #endif
                wait = 0;
        }
        #endif /* (_os_OS_0_STATUS == _os_OS_EXTENDED ) */
  
        _os_SuspendOS();
        if (_os_current_task->set & lmask)
        {
                wait = 0;
        }

        if (!wait)
        {
                 _os_ResumeOS();
                if (_os_NeedToSwitchTasks())
                {
                        /* OS are suspended now */
                        _os_TaskSwitch();
                        /* never here */        
                }
                /* resume and return ret*/
        }
        else
        {
                /* No event specified in 'mask' has been set before, thus the
                * calling task must enter the 'waiting' state. */
                _os_current_task->wait = _os_current_task->events & lmask;
                        
                /* Let us release the internal resource, if present */
                if (_os_current_task->internal!= _os_INVALID_RES)
                {
                       _os_SwapPrioReady(_os_current_task->staticprio);
                       #if ((_os_OS_0_STATUS == _os_OS_EXTENDED )||(_os_OS_0_ORTI))
                       _os_current_task->res   = _os_INVALID_RES;
                       #endif
                }

                #if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
                        _os_LogPlaybackEvent(WAIT_EVENT,
                                (uint8_t)_os_current_task->user_id,
                                (uint32_t)lmask);
                #endif

                /* remove task from the ready to run queue */
                _os_RemoveCurrentTask();
                        
                /* releases scheduler (for non-preemp tasks ) */
                _os_lock = _os_SCHEDULABLE;
                
                /* Save current context and resume next */
                _os_WaitSwitch();
                        
                #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
                if ((_os_current_task->set & lmask)==0)
                {
                        /* the event has not been set !!?? */
                        ShutdownOS(E_OS_SYS_ERROR);
                }
                #endif
        
                /* resume here: _os_lock=-1 */
        } /* wait */
        
        /* system exit actions */
        _os_ServiceExit(_os_N_WaitEvent);
#else
        (void)mask;
#endif
        return ret;
}


