/******************************************************************************
**  FILE:      @(#)c_terminatetask.c    1.25 04/10/13
**  DESCRIPTION:
**      Source code for 'TerminateTask'
******************************************************************************/
#include "c_common.h"
#include "c_target.h"

#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#include "c_postmortem.h"
#endif

StatusType
#if (_os_SIA>0)
_os_TerminateTask
#else
TerminateTask
#endif
(void)
{
        StatusType ret = E_OK;
#if (_os_NO_USER_TASK>0)
        
        _os_lock++;
        
        /* system entry actions */
        _os_ServiceEntry(_os_N_TerminateTask);

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        if ( _os_IsInterruptLevel() )
        {
                ret = E_OS_CALLEVEL;
        }
        else
        /* check if current task owns non-internal resources */
         if ( _os_current_task->res != _os_INVALID_RES                  &&
              _os_resource_table[_os_current_task->res].RESOURCEPROPERTY == _os_RE_STANDARD
            )
         {
                 /* no concurrency problems since only '_os_current_task' can
                  * update '_os_current_task->res' */
                            ret = E_OS_RESOURCE;    
         }
         
         if (ret==E_OK)
         {
        #endif
                
                 _os_SuspendOS();

                #if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
                 _os_LogPlaybackEvent(TASK_TERMINATE,
                                (uint8_t)_os_current_task->user_id,
                                0);
                #endif
        
                 /* If task activation requests are queued */
                if ( _os_current_task->repeat--==1 )
                {
                        /* remove task from 'ready_to_run' queue
                         * if it need not be re-activated */
                        _os_RemoveCurrentTask();

                        /* the task is not in the ready queue anymore */
                        _os_current_task->state=SUSPENDED;
                }
                else
                {
                        /* task keeps populating the ready queue */
                        _os_current_task->state=READY;

                }

                #if (_os_OS_0_ORTI>0)
                _os_current_task->pc = (uintptr_t)_os_current_task->ADDRESS;
                #endif
                
                /* From now on, the history of the task becomes
                * irrelevant ('scheduling' shall happen next).
                * The target routine (_os_ChangeStack()) decides
                * where to keep storing the next locals/parameters/..
                * until a new task is again scheduled (in 'GoToTask').
                * The reason:
                * In some targets, (ex. M32C), the _os_TargetResetTaskContext 
                * routine prepares the next context of the current task
                * for future activations in the task's stack area. 
                * Did we not change here the stack, storing locals from 
                * here and until the scheduler could lead us to data
                * corruption in the task context area.
                * Obviously:
                * From here onwards in this routine, no use of 
                * locals is allowed.
                */
                _os_ChangeStack();
                
                /* Let us now prepare the context of the running task
                 * for future activations */
                _os_TargetResetTaskContext(_os_current_task->user_id);

                #if (_os_OS_0_POSTTASKHOOK==1)
                _os_SETPOSTHOOK();
                PostTaskHook();
                _os_CLRPOSTHOOK();
                #endif
                                  
                #if (_os_OS_0_STACKMONITOR ==1)
                _os_StackMonitor();
                #endif
                
                /* system exit actions */
                _os_ServiceExit(_os_N_TerminateTask);
               
                #if (_os_OS_0_ORTI>0)   
                /* log cycles spent by terminating task */
                _os_UpdateTaskCycles();
                #endif

                /* there is no running task */
                _os_current_task = (_os_RTOSMEM _os_TASK *)0;                           
                
                /* release scheduler (for non-preempt tasks) */
                _os_lock = _os_SCHEDULABLE;
                
                _os_ResumeOS();
                        
                _os_Schedule();

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )       
        }
     
        /* if not internal -> log error */
        #if (_os_OS_0_ERRORHOOK==1)
        _os_LogError(ret,_os_TO_TERMINATE_TASK,-1,-1,-1);
        #endif

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }

        /* system exit actions */
        _os_ServiceExit(_os_N_TerminateTask);
        
        #endif

#endif
        return ret;
}



