/******************************************************************************
**  FILE:      @(#)c_stopcom.c  1.15 04/09/15
**  DESCRIPTION:
**      Source code for 'StopCOM'
******************************************************************************/
#include "c_common.h"
#include "c_target.h"


StatusType
#if (_os_SIA>0)
_os_StopCOM
#else
StopCOM
#endif
(COMShutdownModeType mode )
{
        StatusType ret = E_OK;

        /* system entry actions */
        _os_ServiceEntry(_os_N_StopCOM);

        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        /*'StopCOM' must be called from within a task */
        if (_os_current_task == (_os_RTOSMEM _os_TASK*)0 || _os_IsInterruptLevel())
        {
                ret= E_COM_SYS_LEVEL;
        }
        else
        {
        #endif

        /* warning */
        (void)mode;
                
        /* Declare COM non-Active */
        _os_com_usage = 0;
        
#if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        }
#endif

#if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
#if (_os_COM_0_COMERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_STOP_COM,(int32_t)mode,-1,-1);
        }
#endif
#endif
        /* system exit actions */
        _os_ServiceExit(_os_N_StopCOM);
        
        return ret;             
}





