/******************************************************************************
 *  FILE:      @(#)c_startcom.c 1.15 04/09/15
 *  DESCRIPTION:
 *      Source code for 'StartCOM'
 *****************************************************************************/
#include <osek/osek.h>
#include "c_common.h"
#include "c_target.h"


#if (_os_COM_0_COMSTARTCOMEXTENSION>0)
extern StatusType StartCOMExtension(void);
#endif

_os_RTOSMEM uint_fast8_t                        _os_com_usage;
 /* Storage for application modes */
_os_RTOSMEM COMApplicationModeType      _os_com_mode;

/******************************************************************************
 * FUNCTION:    _os_InitAllMessages
 * DESCRIPTION: Initialisation of Messages (called in _os_StartCOM).
 *****************************************************************************/
#if (_os_NO_MESSAGE > 0)
static void _os_InitAllMessages(void);
#endif

StatusType      
#if (_os_SIA>0)
_os_StartCOM
#else
StartCOM
#endif
(COMApplicationModeType mode )
{
        StatusType ret = E_OK;

        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_StartCOM);

        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        /*'StartCOM' must be called from within a task */
        if (_os_current_task == (_os_TASK*)0 || _os_IsInterruptLevel() )
        {
                ret= E_COM_SYS_LEVEL;
        }
        else
        {
        #endif
        
        /* starts and initialise the OSEK COM implementation
         * in the requested application mode */
        _os_com_mode = mode;

        /* Init the MESSAGEs */
#if (_os_NO_MESSAGE > 0)
        _os_InitAllMessages();
#endif
        #if (_os_COM_0_COMSTARTCOMEXTENSION>0)
        ret= StartCOMExtension(); 
        #endif

        /* Declare COM Active */
        _os_com_usage = 1;

#if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        }
#endif

         #if (_os_COM_0_COMERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_START_COM,(int32_t)mode,-1,-1);
        }
        #endif
        
        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }

        /* system exit actions */
        _os_ServiceExit(_os_N_StartCOM);
        
        return ret;             
}

#if (_os_NO_MESSAGE>0)
static void _os_InitAllMessages(void)
{
        _os_RTOSMEM _os_MESSAGE*    msgptr = &_os_message_table[0];
        SymbolicName    i;

        for (i=0;i<_os_NO_MESSAGE;i++,msgptr++)
        {
                /* Initialisation of only receive messages */
                if(msgptr->MESSAGEPROPERTY != _os_ME_SEND_STATIC_INTERNAL)
                {
                        if (msgptr->MESSAGEPROPERTY == _os_ME_RECEIVE_QUEUED_INTERNAL)
                        {
                                /****************************************************** 
                                 * For queued messages the number of received messages
                                 * must be initialised to zero. There is no need to
                                 * initialise the message object data. 
                                 *****************************************************/
                                msgptr->queuelength =0;
                                msgptr->queuestart  =0;
                        }
                        else if (msgptr->MESSAGEPROPERTY == _os_ME_RECEIVE_UNQUEUED_INTERNAL) 
                        {
                                /************************************************************
                                 * OIL only allows the specification of a limited range of 
                                 * unsigned integer initialization values. This means that 
                                 * OIL can only be used to initialise message that 
                                 * correspond to unsigned integer types within OIL's range
                                 * of values
                                 ************************************************************/
                                if (msgptr->LENGTH == sizeof(unsigned int))
                                {
                                        *( (_os_RTOSMEM unsigned int*)_os_message_data[i] ) = (unsigned int)msgptr->INITIALVALUE;
                                }
                                #if (_os_OS_0_STATUS == _os_OS_EXTENDED)
                                /* for ORTI file */
                                msgptr->queuelength =1;
                                #endif
                        }       
                }
        }
return;
}

#endif /* _os_NO_MESSAGE */

