/******************************************************************************
**  FILE:      @(#)c_setrelalarm.c      1.13 04/09/15
**  DESCRIPTION:
**      Source code for 'SetRelAlarm'           
******************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType    
#if (_os_SIA>0)
_os_SetRelAlarm
#else
SetRelAlarm
#endif
(AlarmType alarm_id, TickType increment, TickType cycle)
{
        StatusType ret = E_OK;
#if (_os_NO_ALARM>0)

        _os_RTOSMEM _os_ALARM*      alarm   = &_os_alarm_table[alarm_id];
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        _os_RTOSMEM _os_COUNTER*    counter = &_os_counter_table[alarm->COUNTER];
        #endif

        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_SetRelAlarm);

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        
        if ( alarm_id < 0 || alarm_id >= _os_NO_ALARM)
        {
                ret = E_OS_ID;
        }
        /* check expiration time is not out of range */
        else if ( increment <= 0 || increment > counter->MAXALLOWEDVALUE )
        {
                ret = E_OS_VALUE;
        }
        /* check cycle time is in range */
        else if ( (cycle != 0)  &&
                  (cycle < counter->MINCYCLE ||
                  cycle > counter->MAXALLOWEDVALUE  )
                )
        {
                ret = E_OS_VALUE;
        }
        else 
        {
        #endif

                ret = _os_SetAlarm(alarm,increment,cycle);
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif 
        
        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_SETREL_ALARM,(int32_t)alarm_id,(int32_t)increment,(int32_t)cycle);
        }
        #endif

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
        
        /* system exit actions */
        _os_ServiceExit(_os_N_SetRelAlarm);

#else
        (void)alarm_id;(void)increment;(void)cycle;
#endif

        return ret;
}

