/******************************************************************************
**  FILE:      @(#)c_setevent.c 1.21 04/10/18
**  DESCRIPTION:
**      Source code for 'SetEvent'
******************************************************************************/
#include "c_common.h"
#include "c_target.h"

#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#include "c_postmortem.h"
#endif

StatusType
#if (_os_SIA>0)
_os_SetEvent
#else
SetEvent
#endif
(TaskType task_id, EventMaskType mask)
{
        StatusType              ret     = E_OK;
#if (_os_NO_EVENT>0)
        _os_EVENTMASKTYPE       lmask   = (_os_EVENTMASKTYPE) mask; 
        _os_RTOSMEM _os_TASK*      task         = &_os_task_table[task_id]; 
#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#if (_os_NO_ISR>0)
         uint8_t id;
#endif
#endif
        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_SetEvent);

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        if ( !(task->events & lmask) )
        {
                /* this mask does not contain any of the task's possible events */
                ret = E_OS_SYS_VALUE;
        }
        else
        {
        #endif

        _os_SuspendOS();
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        if (task->state == SUSPENDED)
        {
                ret = E_OS_STATE;
        }
        else
        {
        #endif
                /* set always the event */
                task->set |= (task->events & lmask);
                      
                if ( task->wait & lmask )
                {
                        /* task is not longer waiting: all should know that */
                        task->wait = 0;
                        #if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
                        # if (_os_NO_ISR>0) 
                        if (_os_IsInterruptLevel())
                        {
                                 id = (uint8_t)(_os_current_isr - &_os_isr_table[0])/sizeof(_os_ISR);
                                _os_LogPlaybackEvent(ISR_EVENT,
                                                (uint8_t)id,
                                                (uint32_t)lmask);
                        }
                        else
                        {
                        #endif  
                                _os_LogPlaybackEvent(TASK_EVENT,
                                                (uint8_t)_os_current_task->user_id,
                                                (uint32_t)lmask);
                        # if (_os_NO_ISR>0) 
                        }
                        #endif
                        #endif
                        
                        /* task was waiting to be awaken by at least one of the 
                        * events contained in the mask. Task must be set to 'ready'.
                        */
                        _os_SetTaskReady(task);
                }       
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif

        _os_ResumeOS();
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_SET_EVENT,(int32_t)task_id,(int32_t)lmask,-1);
        }
        #endif
        #endif
       
        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
        
        /* system exit actions */
        _os_ServiceExit(_os_N_SetEvent);
        
#else
        (void)task_id;(void)mask;
#endif

        
        return ret;

}


