/******************************************************************************
 *  FILE:      @(#)c_setabsalarm.c      1.11 04/09/14
 *  DESCRIPTION:
 *      Source code for 'SetAbsAlarm'                               
******************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType   
#if (_os_SIA>0)
_os_SetAbsAlarm
#else
SetAbsAlarm
#endif
(AlarmType alarm_id, TickType start, TickType cycle)
{
        StatusType ret = E_OK;
#if (_os_NO_ALARM>0)
        _os_RTOSMEM _os_ALARM*      alarm = &_os_alarm_table[alarm_id];
        _os_RTOSMEM _os_COUNTER*    counter = &_os_counter_table[_os_alarm_table[alarm_id].COUNTER];

        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_SetAbsAlarm);
        
        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        if ( alarm_id < 0 || alarm_id >= _os_NO_ALARM)
        {
                ret = E_OS_ID;
        }
        /* check expiration time is not out of range */
        else if ( start <= 0 || start > counter->MAXALLOWEDVALUE )
        {
                ret = E_OS_VALUE;
        }
        /* check cycle time is in range */
        else if ( (cycle != 0)  &&
                  (cycle < counter->MINCYCLE ||
                  cycle > counter->MAXALLOWEDVALUE  )
                )
        {
                ret = E_OS_VALUE;
        }
        else
        {
        #endif
                
                _os_SuspendOS();
                
                if ( start > counter->value )
                {
                        start -=   counter->value;
                } 
                else
                {
                        start = counter->MAXALLOWEDVALUE - counter->value + start;
                }

                ret = _os_SetAlarm(alarm,start,cycle);

                _os_ResumeOS();

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }
        #endif 
 
        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
        }
       #endif

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }

        /* system exit actions */
        _os_ServiceExit(_os_N_SetAbsAlarm);
        
#else
        (void)alarm_id;(void)start;(void)cycle;
#endif

        
        return ret;
}

