/******************************************************************************
 *  FILE:      @(#)c_sendmessage.c      1.19 04/11/17
 *  DESCRIPTION:
 *      Source code for 'SendMessage'
 *****************************************************************************/
#include "c_common.h"
#include "c_target.h"
#include "flag.h"

#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#include "c_postmortem.h"
#endif


/******************************************************************************
 * FUNCTION:    _os_Notify
 * DESCRIPTION: It does perform the NOTIFICATION action indicated for
 *              the message identified by 'msg'.
 *****************************************************************************/
#if (MAX_RECEIVER_MESSAGE>0)
static void _os_Notify(SymbolicName msg);
#endif

#if (_os_NO_MESSAGE>0)
#if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
/******************************************************************************
 * FUNCTION:    _os_IsMessageOwned
 * DESCRIPTION:
 *      It checks that the current running task or ISR owns
 *      the message given as a parameter.
 *****************************************************************************/
StatusType _os_IsMessageOwned(SymbolicName msg);
#endif
#endif

StatusType     
#if (_os_SIA>0)
_os_SendMessage
#else
SendMessage
#endif
(SymbolicName msg, ApplicationDataRef data)
{
        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        StatusType ret = E_COM_ID;
       #else
        StatusType ret = E_OK;
        #endif
        
 #if (_os_NO_MESSAGE > 0)
        #if (MAX_RECEIVER_MESSAGE>0)
       uint_fast8_t i;
        #endif
       _os_RTOSMEM _os_MESSAGE*             msgptr = &_os_message_table[msg];

        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_SendMessage);
        
        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        /************************************************************************
         * - Needs to be a valid sending message object.
         * - Zero or more senders can send to this message obejct, let us
         *   check that the current task/isr is one of them.                    
         ***********************************************************************/
        if ( msg < _os_NO_MESSAGE
             &&  msgptr->MESSAGEPROPERTY == _os_ME_SEND_STATIC_INTERNAL
             && (ret=_os_IsMessageOwned(msg)) == E_OK 
           )
        {
       #else
        #endif
  
        #if (MAX_RECEIVER_MESSAGE>0)
        /********************************************************************
         * find out all receive message objects that must receive the data  *
         * IMPROVEMENT: TOC tool prepares this info for me.                 *
         *******************************************************************/
        for (i=0;msgptr->RECEIVER[i]!= _os_END_SEARCH && i< MAX_RECEIVER_MESSAGE;i++)
        {
                    /* copy data into a receive message object */
                    if( _os_SetDataReceiver(msgptr->RECEIVER[i] ,(uint8_t*)data) )
                    {
                        /* Class 1 Notification of Succesful reception.
                         * Only possible non-succesful reception if receive queue
                         * is overflown.
                         */
                        _os_Notify(msgptr->RECEIVER[i]);
                    }
        
        } /* if (ret==E_OK) */
        #endif
        
        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        }
        #endif


        #if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)
        #if (_os_COM_0_COMERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_SEND_MSG,(int32_t)msg,(int32_t)data,-1);
        }
        #endif
        #endif

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
        
        /* system exit actions */
        _os_ServiceExit(_os_N_SendMessage);
         
#else
        (void)msg;(void)data;
#endif
        return ret;
}


 #if (_os_NO_MESSAGE > 0)


uint_fast8_t _os_SetDataReceiver(SymbolicName msg, uint8_t *src)
{       
        uint_fast8_t ret =1;
        
        /* to copy the msg */
        _os_RTOSMEM uint8_t *dst=0;
        DataLength mlength = _os_message_table[msg].LENGTH;
        _os_RTOSMEM _os_MESSAGE*    msgptr  = &_os_message_table[msg];
 
        /* queueud messages only: next writing -possible-
         * position in the queue */
        uint_fast8_t qid;

        _os_SuspendOS();
        
        /* check out where to copy the data */
        if ( msgptr->MESSAGEPROPERTY==_os_ME_RECEIVE_UNQUEUED_INTERNAL)
        {
                /* message is unqueued */

                dst = (_os_RTOSMEM uint8_t*)_os_message_data[msg];
        
                /* While copying to an unqueued buffer we need 
                 * ALWAYS protection against reentrancy. Imagine that
                 * 'SendMessage()'is preempted -while in the
                 * copy process- with another SendMessage(). */
       
#if (_os_OS_0_LONGMSG>0)
                while(mlength--)
                {
                     *dst++ = *src++;
                }
                _os_ResumeOS();
#endif
        }
        else if ( msgptr->MESSAGEPROPERTY==_os_ME_RECEIVE_QUEUED_INTERNAL )
        {
                /* message is queued */
              
                qid = (msgptr->queuestart + msgptr->queuelength)%msgptr->QUEUESIZE;
                
                if ( msgptr->queuelength >= msgptr->QUEUESIZE)
                {
                        /* 1. queue is full: this message is discarded */
                        msgptr->queuelength = msgptr->QUEUESIZE+1;
                        _os_ResumeOS();
                        ret = 0;
                }
#if (_os_OS_0_LONGMSG>0)
                else if( msgptr->queuestatus & (1 <<qid ) )
                {
                        /* 2. This block still read-busy.
                         *    Imagine a ReceiveMessage() on a full queue.
                         *    The reading process is preempted and 
                         *    SendMessage() is issued. The queue must
                         *    be considered full until the message has
                         *    been completely read first.*/
                        _os_ResumeOS();
                        ret = 0;
                }
#endif
                else 
                {
                        /* 3. queue is now not full */
                        
                        dst = (_os_RTOSMEM uint8_t*) ((_os_RTOSMEM uint8_t*)_os_message_data[msg] +
                                                 qid* mlength );
                        
                        /* Prevent next SendMessage() from overwriting
                         * this block */ 
                        msgptr->queuelength +=1;
#if (_os_OS_0_LONGMSG>0)
                        /* set this buffer to copy-busy */
                        msgptr->queuestatus |= (1<<qid);
                        
                        _os_ResumeOS();
                        
                        /* all locals now */
                        
                        /* Copying needs no protection */
                        while(mlength--)
                        {
                             *dst++ = *src++;
                        }
                        
                        /* set this buffer to free
                         * Protect 'status' */
                        _os_DisableInterrupts();
                        msgptr->queuestatus &= ~(1 << qid);
                        _os_EnableInterrupts();
#endif        
                }
        }

#if (_os_OS_0_LONGMSG ==0)
        /* Short queue messages, enable interrupts
         * while copying is not worth it. */
        if (ret)
        {
                while(mlength--)
                {
                     *dst++ = *src++;
                }
                _os_ResumeOS();
        }
#endif        
        return ret;
}

#if (MAX_RECEIVER_MESSAGE>0)
static void _os_Notify(SymbolicName msg)
{
        _os_OSEKENUM Notification   = _os_message_table[msg].NOTIFICATION;
        _os_RTOSMEM _os_TASK*    task  = &_os_task_table[_os_message_table[msg].TASK];
        _os_EVENTMASKTYPE     mask  = _os_message_table[msg].EVENT;
#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#if (_os_NO_ISR>0)
         uint8_t id;
#endif
#endif
        _os_SuspendOS();  
        switch(Notification)
        {
                case _os_ME_ACTIVATETASK:
                        if ( task->state == SUSPENDED )
                        {
                                 /* Add task at the end of the 
                                  * 'ready to run' queue of its priority level.
                                  */
                                _os_SetTaskReady(task);
                                task->repeat++;
                        }
                        else
                        {
                                /* check number of activations */
                                 if ( task->repeat < task->ACTIVATION )
                                 {
                                       task->repeat++;
                                 }
                        }

                        #if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
                        # if (_os_NO_ISR>0) 
                        if (_os_IsInterruptLevel())
                        {
                                id = (uint8_t)(_os_current_isr - &_os_isr_table[0])/sizeof(_os_ISR);
                                _os_LogPlaybackEvent(ISR_ACTIVATE,
                                                (uint8_t) id,
                                                (uint32_t)task->user_id);
                        }
                        else
                        {
                        #endif
                                _os_LogPlaybackEvent(TASK_ACTIVATE,
                                                (uint8_t)_os_current_task->user_id,
                                                (uint32_t)task->user_id);
                        # if (_os_NO_ISR>0) 
                        }
                        #endif
                        #endif

                        break;
                case _os_ME_SETEVENT:

                        /* set always the event */
                         task->set |= task->events & mask ;
                        
                         if ( task->wait & mask)
                        {
                               /* task was waiting to be awaken by at least one of the 
                                * events contained in the mask. Task must be set to 'ready'.
                                */
                             _os_SetTaskReady(task);
                                /* task is not longer waiting */
                             task->wait = 0;
                
                             #if (_os_OS_0_POSTMORTEM != _os_OS_NONE)
                                /* log an event set from an ISR */
                                # if (_os_NO_ISR>0) 
                                if (_os_IsInterruptLevel())
                                {
                                        id = (uint8_t)(_os_current_isr - &_os_isr_table[0])/sizeof(_os_ISR);
                                        _os_LogPlaybackEvent(ISR_EVENT,
                                                        (uint8_t)id,
                                                        (uint32_t)mask);
                                }
                                else
                                {
                                #endif
                                        _os_LogPlaybackEvent(TASK_EVENT,
                                                        (uint8_t)_os_current_task->user_id,
                                                        (uint32_t)mask);
                                # if (_os_NO_ISR>0) 
                                }
                                #endif
                             #endif
                         }
        
                        _os_ResumeOS();
                        
                        break;
                case _os_ME_COMCALLBACK:
                        _os_SETCALLBACK();
                        ((void(*)(void))_os_message_table[msg].CALLBACKROUTINENAME)();
                        _os_CLRCALLBACK();
                        break;
                case _os_ME_FLAG:
                        _os_DisableInterrupts();
                        _os_flag_table[msg] = COM_TRUE;
                        _os_EnableInterrupts();
                        break;
                case _os_ME_NONE:
                        break;
                default:
                        break;
        }
        
        _os_ResumeOS();
        
        return;
}
#endif


#if (_os_COM_0_COMSTATUS == _os_CO_COMEXTENDED)

StatusType _os_IsMessageOwned(SymbolicName msg)
{
        StatusType      ret = E_COM_ID;
        uint_fast8_t           local;
#if (MAX_MESSAGE_ISR>0)

        if (_os_IsInterruptLevel())
        {
                #if (_os_OS_0_STATUS == _os_OS_EXTENDED)
                /* running at ISR level */
                if ( _os_current_isr->CATEGORY != _os_ISR_CAT1 )
                {
                #endif
                        for (local=0;local<MAX_MESSAGE_ISR && _os_current_isr->MESSAGE[local] != _os_END_SEARCH ;local++)
                        {
                                if ( _os_current_isr->MESSAGE[local] == msg )
                                {
                                        ret = E_OK;
                                        break;
                                }
                        }
                #if (_os_OS_0_STATUS == _os_OS_EXTENDED)
                }
                #endif
        }
        else
        {
#endif
                /* running at task level */

                /* '_os_current_task' needs of no protection */
                for (local=0;local<MAX_MESSAGE_TASK && _os_current_task->MESSAGE[local] != _os_END_SEARCH ;local++)
                {
                        if (_os_current_task->MESSAGE[local] == msg)
                        {
                                ret = E_OK;                     
                                break;
                        }
                }

#if (MAX_MESSAGE_ISR>0)
        }
#endif
        return ret;
}

#endif /* com extended */



 #endif


