/******************************************************************************
**  FILE:      @(#)c_schedule.c 1.15 04/09/14
**  DESCRIPTION:
**      Source code for 'Schedule'
******************************************************************************/
#include "c_common.h"
#include "c_target.h"

StatusType
#if (_os_SIA>0)
_os_Schedule
#else
Schedule
#endif
(void)
{
        StatusType ret = E_OK;
#if (_os_NO_USER_TASK>0)
        _os_RTOSMEM _os_TASK*  task = _os_current_task;

        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_Schedule);

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        
        /* Not from interrupt level */
        if ( _os_IsInterruptLevel() )
        {
                ret = E_OS_CALLEVEL;
        }
        else
        /* Task owns a non-internal resource */
         if (task->res != _os_INVALID_RES
             && _os_resource_table[task->res].RESOURCEPROPERTY != _os_RE_INTERNAL)
         {
                 /* no concurrency problems since only '_os_current_task' can
                  * update '_os_current_task->res' */
                 ret = E_OS_RESOURCE;
         } 
        else
        {
        #endif  

        /* non-preemptable tasks just release scheduler */
        if ( task->SCHEDULE  == _os_TA_NON )
        {
                _os_lock = 0;
        }
        /* group of tasks */
        else if (task->internal  != _os_INVALID_RES)
        {
                _os_SuspendOS();
                if( task->staticprio < _os_NextReadyLevel(task->PRIORITY) )
                {
                        _os_SwapPrioReady(task->staticprio);
                }
                #if ((_os_OS_0_STATUS == _os_OS_EXTENDED)||(_os_OS_0_ORTI>0))
                if (task->internal  != _os_INVALID_RES)
                {
                        _os_current_task->res   = _os_INVALID_RES;
                }
                #endif
                _os_ResumeOS();
        }

        #if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }

        #if (_os_OS_0_ERRORHOOK==1)
        if (ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_SCHEDULE,-1,-1,-1);
        }
        #endif
        #endif

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }
         
        /* system exit actions */
        _os_ServiceExit(_os_N_Schedule);
#endif
         
         return ret;
}

