/******************************************************************************
**  FILE:      @(#)c_releaseresource.c  1.35 04/11/05
**  DESCRIPTION:
**      Source code for 'ReleaseResource'
******************************************************************************/
#include "c_common.h"
#include "c_target.h"
#if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
#include "c_postmortem.h"
#endif

StatusType
#if(_os_SIA>0)
_os_ReleaseResource
#else
ReleaseResource
#endif
(ResourceType sm)
{
       _os_RTOSMEM      _os_RESOURCE*   resptr;
        StatusType      ret    = E_OK;
        uint_fast8_t    prio;

        /* first make the service non-preemptable */
        _os_lock++;

        /* system entry actions */
        _os_ServiceEntry(_os_N_ReleaseResource);

        /* and then initialize all locals */
        resptr = &_os_resource_table[sm];

        #if (_os_OS_0_STACKMONITOR >0)
        /* test stacks are in range */
        _os_CheckStackRange();
        #endif

#if (_os_OS_0_STATUS == _os_OS_EXTENDED )

        #if (_os_OS_0_USERESSCHEDULER==0)
        if(sm==0)
        {
                /* not permission for scheduler resource */
                ret = E_OS_ID;
        }
        else
        #endif
        if (sm >= _os_NO_RESOURCE)
        {
                /* not right ID */
                ret = E_OS_ID;
        }
        else /* resource cannot be internal */
        if( resptr->RESOURCEPROPERTY == _os_RE_INTERNAL )
        {
                ret = E_OS_ID;
        }
        else
        #if (MAX_RESOURCE_ISR>0)
        /* from ISR */  
        if (  _os_IsInterruptLevel() )
        {
                if (!_os_IsResOwnedByCurrentISR(sm))
                {
                        /* undefined if the ISR does not own
                           the resource, ret = E_OS_ID */
                        ret = E_OS_ID;
                }
                else if (_os_current_isr->res != sm)
                {
                        /* another resource has to be released before */
                        ret = E_OS_NOFUNC;
                }
        }
        else
        #endif
        if ( _os_IsTaskLevel() )
        {
                if(!_os_IsResOwnedByCurrentTask(sm))
                {
                        /* undefined if the ISR does not own
                           the resource, ret = E_OS_ID */
                        ret = E_OS_ID;
                }
                else if (_os_current_task->staticprio > resptr->CEILING)
                {
                        /* Attempt to release a resource which has a 
                         * lower ceiling priority than the statically assigned
                         * priority of the calling task or interrupt routine */
                        ret = E_OS_ACCESS;
                }
                else if (_os_current_task->res != sm)
                {
                        /* another resource has to be released before */
                        ret = E_OS_NOFUNC;
                }
        } 

        if (ret == E_OK)
        {
                _os_DisableInterrupts();        
                if (resptr->preprio == 0 )
                {
                        /* Attempt to release a resource which is not 
                         * occupied by any task or ISR */
                        ret = E_OS_NOFUNC;
                }
                _os_EnableInterrupts();
        }
        
        if ( ret == E_OK )
        {
#endif
        
        /* task level: common for Task/ISR ceiling protocol and RES_SCHEDULER */                        
        if ( _os_IsTaskLevel() )
        {
                /* TASK level nested access handling */
                #if ((_os_OS_0_STATUS == _os_OS_EXTENDED)||(_os_OS_0_ORTI>0))
                /* Task shall occupy previous (if any) 
                 * resource after the call -nested resources- */                       
                _os_current_task->res = resptr->nestedto;
                /* this resource will be unlocked, thus being
                 * not nested to other resources */
                resptr->nestedto  = _os_INVALID_RES;
                #endif
        }
                
        #if  (_os_OS_0_ORTI>0)
        /* only for ORTI */
        resptr->locker = 0; 
        #endif          
        
        #if (_os_OS_0_USERESSCHEDULER>0)
        if (sm==0)
        {     
                #if (_os_OS_0_ORTI>0)
                /* ORTI should display now the task as running with
                 * the priority previous to the scheduler's lock. */
                _os_current_task->PRIORITY = resptr->preprio ;
                #endif
                /* we just need to unlock the scheduler */
                resptr->preprio = 0;
                _os_lock--;
        }
        else 
        {
        #endif  

                /* does this resource require extension of the 
                 * ceiling priority protocol to ISR level? */
                if (resptr->isrceiling)
                {
                        /* this could be task or interrupt level */
                        #if (MAX_RESOURCE_ISR>0)
                        #if ((_os_OS_0_STATUS == _os_OS_EXTENDED)||(_os_OS_0_ORTI>0))
                        /* Nested resources at interrupt level */
                        if (  _os_IsInterruptLevel() )
                        { 
                                /* nested accesses */

                                /* no other ISR can yet access the resource */
                                _os_current_isr->res = resptr->nestedto;
                                resptr->nestedto  = _os_INVALID_RES;
                        }
                        #endif
                        _os_ReleaseISRCeilingProtocol(sm);
                        #endif
                }
                else 
                {
                        /* alway task level */
                        /* unlock the resource */               
                        prio = resptr->preprio;
                        resptr->preprio = 0;    
                        
                        if (_os_lock == _os_SCHEDULABLE)
                        {
                                if ( _os_current_task->PRIORITY > prio )
                                {
                                        /* Task Ceiling priority protocol */
                                        _os_SuspendOS();
                                        #if     (_os_OS_0_POSTMORTEM != _os_OS_NONE)
                                        _os_LogPlaybackEvent((uint8_t)LOWER_PRIORITY,
                                                (uint8_t)sm,(uint32_t)prio);
                                        #endif
                                        _os_SwapPrioReady(prio);
                                        _os_ResumeOS();
                                }
                        }
                }              
                
        #if (_os_OS_0_USERESSCHEDULER>0)
        }
        #endif
                        
#if (_os_OS_0_STATUS == _os_OS_EXTENDED )
        }

        #if (_os_OS_0_ERRORHOOK==1)
        if(ret!=E_OK)
        {
                _os_LogError(ret,_os_TO_SEM_GIVE,(int32_t)sm,-1,-1);
        }
        #endif
#endif

        if (_os_NeedToSwitchTasks())
        {
                /* OS are suspended now */
                _os_TaskSwitch();
                /* never here */
        }

        /* system entry actions */
        _os_ServiceExit(_os_N_ReleaseResource);
        
        return ret;

}




